# Docker env
DOCKER_REGISTRY ?= registry.redhat.io
DOCKER_ORG      ?= amq7
DOCKER_ORG_PREVIEW ?= amq7-tech-preview
DOCKER          ?= docker
PROJECT_PREFIX  ?= enmasse
PROJECT_NAME    ?= $(shell basename $(CURDIR))
COMMIT          ?= $(shell git rev-parse HEAD)
VERSION         ?= $(shell grep "release.version" $(TOPDIR)/pom.properties| cut -d'=' -f2)
MAVEN_VERSION   ?= $(shell grep "maven.version" $(TOPDIR)/pom.properties| cut -d'=' -f2)
TAG             ?= latest

# Go settings
GOPATH          := $(abspath $(TOPDIR))/go
GOPRJ           := $(GOPATH)/src/github.com/enmasseproject/enmasse
export GOPATH

# Image settings
DOCKER_REGISTRY_PREFIX ?= $(DOCKER_REGISTRY)/
IMAGE_VERSION          ?= $(TAG)
ADDRESS_SPACE_CONTROLLER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-address-space-controller:$(IMAGE_VERSION)
API_SERVER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-api-server:$(IMAGE_VERSION)
STANDARD_CONTROLLER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-standard-controller:$(IMAGE_VERSION)
ROUTER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)amq7/amq-interconnect:1.5
BROKER_PLUGIN_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-broker-plugin:$(IMAGE_VERSION)
TOPIC_FORWARDER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-topic-forwarder:$(IMAGE_VERSION)
AGENT_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-agent:$(IMAGE_VERSION)
MQTT_GATEWAY_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-mqtt-gateway:$(IMAGE_VERSION)
MQTT_LWT_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-mqtt-lwt:$(IMAGE_VERSION)
NONE_AUTHSERVICE_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-none-auth-service:$(IMAGE_VERSION)
KEYCLOAK_IMAGE ?= registry.redhat.io/redhat-sso-7/sso73-openshift:latest
KEYCLOAK_PLUGIN_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-auth-plugin:$(IMAGE_VERSION)
SERVICE_BROKER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-service-broker:$(IMAGE_VERSION)
CONSOLE_INIT_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-console-init:$(IMAGE_VERSION)
CONSOLE_PROXY_OPENSHIFT_IMAGE ?= openshift/oauth-proxy:latest
CONSOLE_PROXY_KUBERNETES_IMAGE ?= quay.io/pusher/oauth2_proxy:latest
CONSOLE_HTTPD_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-console-httpd:$(IMAGE_VERSION)
PROMETHEUS_IMAGE ?= prom/prometheus:v2.4.3
ALERTMANAGER_IMAGE ?= prom/alertmanager:v0.15.2
GRAFANA_IMAGE ?= grafana/grafana:5.3.1
APPLICATION_MONITORING_OPERATOR_IMAGE ?= quay.io/integreatly/application-monitoring-operator:0.0.5
KUBE_STATE_METRICS_IMAGE ?= quay.io/coreos/kube-state-metrics:v1.4.0
QDROUTERD_BASE_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)amq7/amq-interconnect:1.5
BROKER_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)amq-broker-7/amq-broker-74-openshift:latest
OAUTH_PROXY_IMAGE ?= openshift/oauth-proxy:latest

CONTROLLER_MANAGER_IMAGE   ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG)/amq-online-1-controller-manager:$(IMAGE_VERSION)

IOT_AUTH_SERVICE_IMAGE             ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-auth-service:$(IMAGE_VERSION)
IOT_DEVICE_REGISTRY_FILE_IMAGE     ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-device-registry-file:$(IMAGE_VERSION)
IOT_DEVICE_REGISTRY_INFINISPAN_IMAGE ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-device-registry-datagrid:$(IMAGE_VERSION)
IOT_GC_IMAGE                       ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-gc:$(IMAGE_VERSION)
IOT_HTTP_ADAPTER_IMAGE             ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-http-adapter:$(IMAGE_VERSION)
IOT_MQTT_ADAPTER_IMAGE             ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-mqtt-adapter:$(IMAGE_VERSION)
IOT_TENANT_SERVICE_IMAGE           ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-tenant-service:$(IMAGE_VERSION)
IOT_PROXY_CONFIGURATOR_IMAGE       ?= $(DOCKER_REGISTRY_PREFIX)$(DOCKER_ORG_PREVIEW)/amq-online-1-iot-proxy-configurator:$(IMAGE_VERSION)


DEFAULT_PROJECT ?= amq-online-infra
ifeq ($(TAG),latest)
IMAGE_PULL_POLICY ?= Always
else
IMAGE_PULL_POLICY ?= Always
endif

IMAGE_ENV=ADDRESS_SPACE_CONTROLLER_IMAGE=$(ADDRESS_SPACE_CONTROLLER_IMAGE) \
			API_SERVER_IMAGE=$(API_SERVER_IMAGE) \
			STANDARD_CONTROLLER_IMAGE=$(STANDARD_CONTROLLER_IMAGE) \
			ROUTER_IMAGE=$(ROUTER_IMAGE) \
			BROKER_IMAGE=$(BROKER_IMAGE) \
			BROKER_PLUGIN_IMAGE=$(BROKER_PLUGIN_IMAGE) \
			TOPIC_FORWARDER_IMAGE=$(TOPIC_FORWARDER_IMAGE) \
			SUBSERV_IMAGE=$(SUBSERV_IMAGE) \
			SERVICE_BROKER_IMAGE=$(SERVICE_BROKER_IMAGE) \
			NONE_AUTHSERVICE_IMAGE=$(NONE_AUTHSERVICE_IMAGE) \
			AGENT_IMAGE=$(AGENT_IMAGE) \
			KEYCLOAK_IMAGE=$(KEYCLOAK_IMAGE) \
			KEYCLOAK_PLUGIN_IMAGE=$(KEYCLOAK_PLUGIN_IMAGE) \
			MQTT_GATEWAY_IMAGE=$(MQTT_GATEWAY_IMAGE) \
			MQTT_LWT_IMAGE=$(MQTT_LWT_IMAGE) \
			CONSOLE_INIT_IMAGE=$(CONSOLE_INIT_IMAGE) \
			CONSOLE_PROXY_OPENSHIFT_IMAGE=$(CONSOLE_PROXY_OPENSHIFT_IMAGE) \
			CONSOLE_PROXY_KUBERNETES_IMAGE=$(CONSOLE_PROXY_KUBERNETES_IMAGE) \
			CONSOLE_HTTPD_IMAGE=$(CONSOLE_HTTPD_IMAGE) \
			PROMETHEUS_IMAGE=$(PROMETHEUS_IMAGE) \
			ALERTMANAGER_IMAGE=$(ALERTMANAGER_IMAGE) \
			GRAFANA_IMAGE=$(GRAFANA_IMAGE) \
			APPLICATION_MONITORING_OPERATOR_IMAGE=$(APPLICATION_MONITORING_OPERATOR_IMAGE) \
			KUBE_STATE_METRICS_IMAGE=$(KUBE_STATE_METRICS_IMAGE) \
			QDROUTERD_BASE_IMAGE=$(QDROUTERD_BASE_IMAGE) \
			CONTROLLER_MANAGER_IMAGE=$(CONTROLLER_MANAGER_IMAGE) \
			IOT_PROXY_CONFIGURATOR_IMAGE=$(IOT_PROXY_CONFIGURATOR_IMAGE) \
			IOT_AUTH_SERVICE_IMAGE=$(IOT_AUTH_SERVICE_IMAGE) \
			IOT_DEVICE_REGISTRY_FILE_IMAGE=$(IOT_DEVICE_REGISTRY_FILE_IMAGE) \
			IOT_GC_IMAGE=$(IOT_GC_IMAGE) \
			IOT_HTTP_ADAPTER_IMAGE=$(IOT_HTTP_ADAPTER_IMAGE) \
			IOT_MQTT_ADAPTER_IMAGE=$(IOT_MQTT_ADAPTER_IMAGE) \
			IOT_TENANT_SERVICE_IMAGE=$(IOT_TENANT_SERVICE_IMAGE) \
			IMAGE_PULL_POLICY=$(IMAGE_PULL_POLICY) \
			ENMASSE_VERSION=$(VERSION) \
			MAVEN_VERSION=$(MAVEN_VERSION) \
			PROJECT_PREFIX=$(PROJECT_PREFIX)

IMAGE_LIST=$(ADDRESS_SPACE_CONTROLLER_IMAGE) \
                        $(API_SERVER_IMAGE) \
                        $(STANDARD_CONTROLLER_IMAGE) \
                        $(ROUTER_IMAGE) \
                        $(BROKER_IMAGE) \
                        $(BROKER_PLUGIN_IMAGE) \
                        $(TOPIC_FORWARDER_IMAGE) \
                        $(AGENT_IMAGE) \
                        $(MQTT_GATEWAY_IMAGE) \
                        $(MQTT_LWT_IMAGE) \
                        $(NONE_AUTHSERVICE_IMAGE) \
                        $(KEYCLOAK_PLUGIN_IMAGE) \
                        $(SERVICE_BROKER_IMAGE) \
                        $(CONSOLE_INIT_IMAGE) \
                        $(CONSOLE_HTTPD_IMAGE) \
                        $(CONTROLLER_MANAGER_IMAGE) \
                        $(IOT_AUTH_SERVICE_IMAGE) \
                        $(IOT_DEVICE_REGISTRY_FILE_IMAGE) \
                        $(IOT_GC_IMAGE) \
                        $(IOT_HTTP_ADAPTER_IMAGE) \
                        $(IOT_MQTT_ADAPTER_IMAGE) \
                        $(IOT_TENANT_SERVICE_IMAGE) \
                        $(IOT_PROXY_CONFIGURATOR_IMAGE) \
