/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	iotv1alpha1 "github.com/enmasseproject/enmasse/pkg/apis/iot/v1alpha1"
	versioned "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned"
	internalinterfaces "github.com/enmasseproject/enmasse/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/enmasseproject/enmasse/pkg/client/listers/iot/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// IoTProjectInformer provides access to a shared informer and lister for
// IoTProjects.
type IoTProjectInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.IoTProjectLister
}

type ioTProjectInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewIoTProjectInformer constructs a new informer for IoTProject type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewIoTProjectInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredIoTProjectInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredIoTProjectInformer constructs a new informer for IoTProject type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredIoTProjectInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.IotV1alpha1().IoTProjects(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.IotV1alpha1().IoTProjects(namespace).Watch(options)
			},
		},
		&iotv1alpha1.IoTProject{},
		resyncPeriod,
		indexers,
	)
}

func (f *ioTProjectInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredIoTProjectInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *ioTProjectInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&iotv1alpha1.IoTProject{}, f.defaultInformer)
}

func (f *ioTProjectInformer) Lister() v1alpha1.IoTProjectLister {
	return v1alpha1.NewIoTProjectLister(f.Informer().GetIndexer())
}
