[![Strimzi](./documentation/logo/strimzi.png)](http://strimzi.io/)

# Run Apache Kafka on Kubernetes and OpenShift

[![Build Status](https://travis-ci.org/strimzi/strimzi-kafka-operator.svg?branch=master)](https://travis-ci.org/strimzi/strimzi-kafka-operator)
[![GitHub release](https://img.shields.io/github/release/strimzi/strimzi-kafka-operator.svg)](https://github.com/strimzi/strimzi-kafka-operator/releases/latest)
[![License](https://img.shields.io/badge/license-Apache--2.0-blue.svg)](http://www.apache.org/licenses/LICENSE-2.0)
[![Twitter Follow](https://img.shields.io/twitter/follow/strimziio.svg?style=social&label=Follow&style=for-the-badge)](https://twitter.com/strimziio)

Strimzi provides a way to run an [Apache Kafka][kafka] cluster on 
[Kubernetes][k8s] or [OpenShift][os] in various deployment configurations.
See our [website][strimzi] for more details about the project.

## Quickstart

To get up and running quickly, check our Quickstart guides for [OKD (OpenShift Origin)](http://strimzi.io/quickstarts/okd/) and [Minikube](http://strimzi.io/quickstarts/minikube/). 

## Documentation

Documentation to the current _master_ branch as well as all releases can be found on our [website][strimzi].

## Getting help

If you encounter any issues while using Strimzi, you can get help using:

- [Strimzi mailing list](https://www.redhat.com/mailman/listinfo/strimzi)
- [Strimzi Slack workspace](https://join.slack.com/t/strimzi/shared_invite/enQtMzU2Mjk3NTgxMzE5LTYyMTUwMGNlMDQwMzBhOGI4YmY4MjhiMDgyNjA5OTk2MTFiYjc4M2Q3NGU1YTFjOWRiMzM2NGMwNDUwMjBlNDY)

## Contributing

You can contribute by:
- Raising any issues you find using Strimzi
- Fixing issues by opening Pull Requests
- Improving documentation
- Talking about Strimzi

All bugs, tasks or enhancements are tracked as [GitHub issues](https://github.com/strimzi/strimzi-kafka-operator/issues). Issues which 
might be a good start for new contributors are marked with ["good-start"](https://github.com/strimzi/strimzi-kafka-operator/labels/good-start)
label.

The [Hacking guide](https://github.com/strimzi/strimzi-kafka-operator/blob/master/HACKING.md) describes how to build Strimzi and how to 
test your changes before submitting a patch or opening a PR.

The [Documentation Contributor Guide](http://strimzi.io/contributing/guide/) describes how to contribute to Strimzi documentation.

If you want to get in touch with us first before contributing, you can use:

- [Strimzi mailing list](https://www.redhat.com/mailman/listinfo/strimzi)
- [Strimzi Slack workspace](https://join.slack.com/t/strimzi/shared_invite/enQtMzU2Mjk3NTgxMzE5LTYyMTUwMGNlMDQwMzBhOGI4YmY4MjhiMDgyNjA5OTk2MTFiYjc4M2Q3NGU1YTFjOWRiMzM2NGMwNDUwMjBlNDY)

## License
Strimzi is licensed under the [Apache License](./LICENSE), Version 2.0

[strimzi]: http://strimzi.io "Strimzi"
[kafka]: https://kafka.apache.org "Apache Kafka"
[k8s]: https://kubernetes.io/ "Kubernetes"
[os]: https://www.openshift.com/ "OpenShift"
