[![Strimzi](./documentation/logo/strimzi.png)](https://strimzi.io/)

# Run Apache Kafka on Kubernetes and OpenShift

[![Build Status](https://travis-ci.org/strimzi/strimzi-kafka-operator.svg?branch=master)](https://travis-ci.org/strimzi/strimzi-kafka-operator)
[![Build Status](https://dev.azure.com/cncf/strimzi/_apis/build/status/build?branchName=master)](https://dev.azure.com/cncf/strimzi/_build/latest?definitionId=16&branchName=master)
[![GitHub release](https://img.shields.io/github/release/strimzi/strimzi-kafka-operator.svg)](https://github.com/strimzi/strimzi-kafka-operator/releases/latest)
[![License](https://img.shields.io/badge/license-Apache--2.0-blue.svg)](http://www.apache.org/licenses/LICENSE-2.0)
[![Twitter Follow](https://img.shields.io/twitter/follow/strimziio.svg?style=social&label=Follow&style=for-the-badge)](https://twitter.com/strimziio)

Strimzi provides a way to run an [Apache Kafka][kafka] cluster on 
[Kubernetes][k8s] or [OpenShift][os] in various deployment configurations.
See our [website][strimzi] for more details about the project.

## Quick Starts

To get up and running quickly, check our [Quick Start for Minikube, OKD (OpenShift Origin) and Kubernetes Kind](https://strimzi.io/quickstarts/). 

## Documentation

Documentation to the current _master_ branch as well as all releases can be found on our [website][strimzi].

## Getting help

If you encounter any issues while using Strimzi, you can get help using:

- [#strimzi channel on CNCF Slack](https://slack.cncf.io/)
- [Strimzi Users mailing list](https://lists.cncf.io/g/cncf-strimzi-users/topics)

## Contributing

You can contribute by:
- Raising any issues you find using Strimzi
- Fixing issues by opening Pull Requests
- Improving documentation
- Talking about Strimzi

All bugs, tasks or enhancements are tracked as [GitHub issues](https://github.com/strimzi/strimzi-kafka-operator/issues). Issues which 
might be a good start for new contributors are marked with ["good-start"](https://github.com/strimzi/strimzi-kafka-operator/labels/good-start)
label.

The [Hacking guide](https://github.com/strimzi/strimzi-kafka-operator/blob/master/HACKING.md) describes how to build Strimzi and how to 
test your changes before submitting a patch or opening a PR.

The [Documentation Contributor Guide](https://strimzi.io/contributing/guide/) describes how to contribute to Strimzi documentation.

If you want to get in touch with us first before contributing, you can use:

- [#strimzi channel on CNCF Slack](https://slack.cncf.io/)
- [Strimzi Dev mailing list](https://lists.cncf.io/g/cncf-strimzi-dev/topics)

## License
Strimzi is licensed under the [Apache License](./LICENSE), Version 2.0

---

Strimzi is a <a href="http://cncf.io">Cloud Native Computing Foundation</a> sandbox project.

![CNCF ><](./documentation/logo/cncf-color.png)

[strimzi]: https://strimzi.io "Strimzi"
[kafka]: https://kafka.apache.org "Apache Kafka"
[k8s]: https://kubernetes.io/ "Kubernetes"
[os]: https://www.openshift.com/ "OpenShift"
