#!/usr/bin/env bash

source $(dirname $(realpath $0))/../tools/kafka-versions-tools.sh

# Generates documentation/book/ref-kafka-versions.adoc
# according to the values in kafka-versions

. $(dirname $0)/../tools/multi-platform-support.sh

# Parse the Kafka versions file and get a list of version strings in an array
# called "versions" and likewise for protocols, formats and zookeeper versions
get_kafka_versions
get_zookeeper_versions
get_kafka_protocols
get_kafka_formats

cat <<EOF
// This assembly is included in the following assemblies:
//
// assembly_upgrade-kafka-versions.adoc
// Generated by documentation/supported-version.sh during the build
// DO NOT EDIT BY HAND
[options="header"]
|=================
|Kafka version |Interbroker protocol version |Log message format version| ZooKeeper version
EOF
for i in "${!versions[@]}"
do
    echo "| ${versions[$i]} | ${protocols[$i]} | ${formats[$i]} | ${zk_versions[$i]}"
done
cat <<EOF
|=================
EOF
