/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionClause<T>
extends ExpressionDefinition {
    private T result;
    private String language;

    public ExpressionClause(T result) {
        this.result = result;
    }

    public static <T extends ExpressionNode> ExpressionClause<T> createAndSetExpression(T result) {
        ExpressionClause<T> clause = new ExpressionClause<T>(result);
        result.setExpression(clause);
        return clause;
    }

    public T expression(Expression expression) {
        this.setExpressionValue(expression);
        return this.result;
    }

    public T constant(Object value) {
        return this.expression(ExpressionBuilder.constantExpression(value));
    }

    public T exchange() {
        return this.expression(ExpressionBuilder.exchangeExpression());
    }

    public T inMessage() {
        return this.expression(ExpressionBuilder.inMessageExpression());
    }

    public T outMessage() {
        return this.expression(ExpressionBuilder.outMessageExpression());
    }

    public T body() {
        return this.expression(ExpressionBuilder.bodyExpression());
    }

    public T body(Class<?> expectedType) {
        return this.expression(ExpressionBuilder.bodyExpression(expectedType));
    }

    public T outBody() {
        return this.expression(ExpressionBuilder.outBodyExpression());
    }

    public T outBody(Class expectedType) {
        return this.expression(ExpressionBuilder.outBodyExpression(expectedType));
    }

    public T header(String name) {
        return this.expression(ExpressionBuilder.headerExpression(name));
    }

    public T headers() {
        return this.expression(ExpressionBuilder.headersExpression());
    }

    public T outHeader(String name) {
        return this.expression(ExpressionBuilder.outHeaderExpression(name));
    }

    public T outHeaders() {
        return this.expression(ExpressionBuilder.outHeadersExpression());
    }

    public T property(String name) {
        return this.expression(ExpressionBuilder.propertyExpression(name));
    }

    public T properties() {
        return this.expression(ExpressionBuilder.propertiesExpression());
    }

    public T method(String bean) {
        MethodCallExpression expression = new MethodCallExpression(bean);
        this.setExpressionType(expression);
        return this.result;
    }

    public T method(Class<?> beanType) {
        MethodCallExpression expression = new MethodCallExpression(beanType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T method(String bean, String method) {
        MethodCallExpression expression = new MethodCallExpression(bean, method);
        this.setExpressionType(expression);
        return this.result;
    }

    public T method(Class<?> beanType, String method) {
        MethodCallExpression expression = new MethodCallExpression(beanType, method);
        this.setExpressionType(expression);
        return this.result;
    }

    public T el(String text) {
        return this.language("el", text);
    }

    public T groovy(String text) {
        return this.language("groovy", text);
    }

    public T javaScript(String text) {
        return this.language("js", text);
    }

    public T jxpath(String text) {
        return this.language("jxpath", text);
    }

    public T ognl(String text) {
        return this.language("ognl", text);
    }

    public T mvel(String text) {
        return this.language("mvel", text);
    }

    public T php(String text) {
        return this.language("php", text);
    }

    public T python(String text) {
        return this.language("python", text);
    }

    public T ruby(String text) {
        return this.language("ruby", text);
    }

    public T sql(String text) {
        return this.language("sql", text);
    }

    public T simple(String text) {
        return this.language("simple", text);
    }

    public T xpath(String text) {
        return this.language("xpath", text);
    }

    public T xpath(String text, Class<?> resultType) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text, Class<?> resultType, Namespaces namespaces) {
        return this.xpath(text, resultType, namespaces.getNamespaces());
    }

    public T xpath(String text, Class<?> resultType, Map<String, String> namespaces) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text, Namespaces namespaces) {
        return this.xpath(text, namespaces.getNamespaces());
    }

    public T xpath(String text, Map<String, String> namespaces) {
        XPathExpression expression = new XPathExpression(text);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text) {
        return this.language("xquery", text);
    }

    public T xquery(String text, Class<?> resultType) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text, Class<?> resultType, Namespaces namespaces) {
        return this.xquery(text, resultType, namespaces.getNamespaces());
    }

    public T xquery(String text, Class<?> resultType, Map<String, String> namespaces) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text, Namespaces namespaces) {
        return this.xquery(text, namespaces.getNamespaces());
    }

    public T xquery(String text, Map<String, String> namespaces) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T language(String language, String expression) {
        this.setLanguage(language);
        this.setExpression(expression);
        return this.result;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

