/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;

public abstract class RouteBuilder
extends BuilderSupport
implements RoutesBuilder {
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private RoutesDefinition routeCollection = new RoutesDefinition();

    public RouteBuilder() {
        this(null);
    }

    public RouteBuilder(CamelContext context) {
        super(context);
    }

    public String toString() {
        return this.routeCollection.toString();
    }

    public abstract void configure() throws Exception;

    public RouteDefinition from(String uri) {
        this.routeCollection.setCamelContext(this.getContext());
        RouteDefinition answer = this.routeCollection.from(uri);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition fromF(String uri, Object ... args) {
        this.routeCollection.setCamelContext(this.getContext());
        RouteDefinition answer = this.routeCollection.from(String.format(uri, args));
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.routeCollection.setCamelContext(this.getContext());
        RouteDefinition answer = this.routeCollection.from(endpoint);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(String ... uris) {
        this.routeCollection.setCamelContext(this.getContext());
        RouteDefinition answer = this.routeCollection.from(uris);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        this.routeCollection.setCamelContext(this.getContext());
        RouteDefinition answer = this.routeCollection.from(endpoints);
        this.configureRoute(answer);
        return answer;
    }

    public RouteBuilder errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        this.routeCollection.setCamelContext(this.getContext());
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return this;
    }

    public InterceptDefinition intercept() {
        this.routeCollection.setCamelContext(this.getContext());
        return this.routeCollection.intercept();
    }

    public InterceptFromDefinition interceptFrom() {
        this.routeCollection.setCamelContext(this.getContext());
        return this.routeCollection.interceptFrom();
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        this.routeCollection.setCamelContext(this.getContext());
        return this.routeCollection.interceptFrom(uri);
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        this.routeCollection.setCamelContext(this.getContext());
        return this.routeCollection.interceptSendToEndpoint(uri);
    }

    public OnExceptionDefinition onException(Class exception) {
        this.routeCollection.setCamelContext(this.getContext());
        return this.routeCollection.onException(exception);
    }

    public OnExceptionDefinition onException(Class ... exceptions) {
        OnExceptionDefinition last = null;
        for (Class ex : exceptions) {
            last = last == null ? this.onException(ex) : last.onException(ex);
        }
        return last != null ? last : this.onException((Class)Exception.class);
    }

    public OnCompletionDefinition onCompletion() {
        this.routeCollection.setCamelContext(this.getContext());
        return this.routeCollection.onCompletion();
    }

    public CamelContext getContext() {
        CamelContext context = super.getContext();
        if (context == null) {
            context = this.createContainer();
            this.setContext(context);
        }
        return context;
    }

    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        this.configureRoutes(context);
        this.populateRoutes();
    }

    public RoutesDefinition configureRoutes(CamelContext context) throws Exception {
        this.setContext(context);
        this.checkInitialized();
        this.routeCollection.setCamelContext(context);
        return this.routeCollection;
    }

    public void includeRoutes(RoutesBuilder routes) throws Exception {
        if (routes instanceof RouteBuilder) {
            RouteBuilder builder = (RouteBuilder)routes;
            builder.setContext(this.getContext());
            builder.setRouteCollection(this.getRouteCollection());
            builder.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
            builder.configure();
        } else {
            this.getContext().addRoutes(routes);
        }
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        super.setErrorHandlerBuilder(errorHandlerBuilder);
        this.routeCollection.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
    }

    protected void checkInitialized() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            CamelContext camelContext = this.getContext();
            if (camelContext.getErrorHandlerBuilder() != null) {
                this.setErrorHandlerBuilder(camelContext.getErrorHandlerBuilder());
            }
            this.configure();
        }
    }

    protected void populateRoutes() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.routeCollection.setCamelContext(camelContext);
        camelContext.addRouteDefinitions(this.routeCollection.getRoutes());
    }

    public void setRouteCollection(RoutesDefinition routeCollection) {
        this.routeCollection = routeCollection;
    }

    public RoutesDefinition getRouteCollection() {
        return this.routeCollection;
    }

    protected CamelContext createContainer() {
        return new DefaultCamelContext();
    }

    protected void configureRoute(RouteDefinition route) {
        route.setGroup(this.getClass().getName());
    }

    @Deprecated
    protected void addRoutes(RoutesBuilder routes) throws Exception {
        this.includeRoutes(routes);
    }
}

