/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.PredicateAssertHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssertionClause
implements Runnable {
    private List<Predicate> predicates = new ArrayList<Predicate>();

    public AssertionClause predicate(Predicate predicate) {
        this.addPredicate(predicate);
        return this;
    }

    public ExpressionClause<AssertionClause> predicate() {
        ExpressionClause<AssertionClause> clause = new ExpressionClause<AssertionClause>(this);
        this.addPredicate(clause);
        return clause;
    }

    public ValueBuilder header(String name) {
        Expression expression = ExpressionBuilder.headerExpression(name);
        return new PredicateValueBuilder(expression);
    }

    public ValueBuilder property(String name) {
        Expression expression = ExpressionBuilder.propertyExpression(name);
        return new PredicateValueBuilder(expression);
    }

    public PredicateValueBuilder body() {
        Expression expression = ExpressionBuilder.bodyExpression();
        return new PredicateValueBuilder(expression);
    }

    public <T> PredicateValueBuilder body(Class<T> type) {
        Expression expression = ExpressionBuilder.bodyExpression(type);
        return new PredicateValueBuilder(expression);
    }

    public PredicateValueBuilder outBody() {
        Expression expression = ExpressionBuilder.outBodyExpression();
        return new PredicateValueBuilder(expression);
    }

    public <T> PredicateValueBuilder outBody(Class<T> type) {
        Expression expression = ExpressionBuilder.outBodyExpression(type);
        return new PredicateValueBuilder(expression);
    }

    protected void applyAssertionOn(MockEndpoint endpoint, int index, Exchange exchange) {
        for (Predicate predicate : this.predicates) {
            PredicateAssertHelper.assertMatches(predicate, endpoint.getEndpointUri() + " ", exchange);
        }
    }

    protected void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    public class PredicateValueBuilder
    extends ValueBuilder {
        public PredicateValueBuilder(Expression expression) {
            super(expression);
        }

        protected Predicate onNewPredicate(Predicate predicate) {
            AssertionClause.this.addPredicate(predicate);
            return predicate;
        }
    }
}

