/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConsumerTemplate
implements ConsumerTemplate {
    private final CamelContext context;
    private final ConsumerCache consumerCache = new ConsumerCache();

    public DefaultConsumerTemplate(CamelContext context) {
        this.context = context;
    }

    @Override
    public void start() throws Exception {
        this.consumerCache.start();
    }

    @Override
    public void stop() throws Exception {
        this.consumerCache.stop();
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public Exchange receive(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.consumerCache.receive(endpoint);
    }

    @Override
    public Exchange receive(Endpoint endpoinit) {
        return this.receive(endpoinit.getEndpointUri());
    }

    @Override
    public Exchange receive(String endpointUri, long timeout) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.consumerCache.receive(endpoint, timeout);
    }

    @Override
    public Exchange receive(Endpoint endpoint, long timeout) {
        return this.receive(endpoint.getEndpointUri(), timeout);
    }

    @Override
    public Exchange receiveNoWait(String endpointUri) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.consumerCache.receiveNoWait(endpoint);
    }

    @Override
    public Exchange receiveNoWait(Endpoint endpoint) {
        return this.receiveNoWait(endpoint.getEndpointUri());
    }

    @Override
    public Object receiveBody(String endpointUri) {
        Exchange exchange = this.receive(endpointUri);
        return this.extractResultBody(exchange);
    }

    @Override
    public Object receiveBody(Endpoint endpoint) {
        return this.receiveBody(endpoint.getEndpointUri());
    }

    @Override
    public Object receiveBody(String endpointUri, long timeout) {
        Exchange exchange = this.receive(endpointUri, timeout);
        return this.extractResultBody(exchange);
    }

    @Override
    public Object receiveBody(Endpoint endpoint, long timeout) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout);
    }

    @Override
    public Object receiveBodyNoWait(String endpointUri) {
        Exchange exchange = this.receiveNoWait(endpointUri);
        return this.extractResultBody(exchange);
    }

    @Override
    public Object receiveBodyNoWait(Endpoint endpoint) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri());
    }

    @Override
    public <T> T receiveBody(String endpointUri, Class<T> type) {
        Object body = this.receiveBody(endpointUri);
        return this.context.getTypeConverter().convertTo(type, body);
    }

    @Override
    public <T> T receiveBody(Endpoint endpoint, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), type);
    }

    @Override
    public <T> T receiveBody(String endpointUri, long timeout, Class<T> type) {
        Object body = this.receiveBody(endpointUri, timeout);
        return this.context.getTypeConverter().convertTo(type, body);
    }

    @Override
    public <T> T receiveBody(Endpoint endpoint, long timeout, Class<T> type) {
        return this.receiveBody(endpoint.getEndpointUri(), timeout, type);
    }

    @Override
    public <T> T receiveBodyNoWait(String endpointUri, Class<T> type) {
        Object body = this.receiveBodyNoWait(endpointUri);
        return this.context.getTypeConverter().convertTo(type, body);
    }

    @Override
    public <T> T receiveBodyNoWait(Endpoint endpoint, Class<T> type) {
        return this.receiveBodyNoWait(endpoint.getEndpointUri(), type);
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        return CamelContextHelper.getMandatoryEndpoint(this.context, endpointUri);
    }

    protected Object extractResultBody(Exchange result) {
        Object answer = null;
        if (result != null) {
            if (result.getException() != null) {
                throw ObjectHelper.wrapRuntimeCamelException(result.getException());
            }
            answer = result.hasOut() ? result.getOut().getBody() : result.getIn().getBody();
        }
        return answer;
    }
}

