/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.builder.FileExpressionBuilder;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.language.simple.SimpleLanguageSupport;
import org.apache.camel.util.ObjectHelper;

public class FileLanguage
extends SimpleLanguageSupport {
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();

    public static Expression file(String expression) {
        FileLanguage language = new FileLanguage();
        return language.createExpression(expression);
    }

    protected Expression createSimpleExpression(String expression, boolean strict) {
        String remainder = this.ifStartsWithReturnRemainder("file:", expression);
        if (remainder != null) {
            if (ObjectHelper.equal(remainder, "name")) {
                return FileExpressionBuilder.fileNameExpression();
            }
            if (ObjectHelper.equal(remainder, "name.noext")) {
                return FileExpressionBuilder.fileNameNoExtensionExpression();
            }
            if (ObjectHelper.equal(remainder, "onlyname")) {
                return FileExpressionBuilder.fileOnlyNameExpression();
            }
            if (ObjectHelper.equal(remainder, "onlyname.noext")) {
                return FileExpressionBuilder.fileOnlyNameNoExtensionExpression();
            }
            if (ObjectHelper.equal(remainder, "ext")) {
                return FileExpressionBuilder.fileExtensionExpression();
            }
            if (ObjectHelper.equal(remainder, "parent")) {
                return FileExpressionBuilder.fileParentExpression();
            }
            if (ObjectHelper.equal(remainder, "path")) {
                return FileExpressionBuilder.filePathExpression();
            }
            if (ObjectHelper.equal(remainder, "absolute")) {
                return FileExpressionBuilder.fileAbsoluteExpression();
            }
            if (ObjectHelper.equal(remainder, "absolute.path")) {
                return FileExpressionBuilder.fileAbsolutePathExpression();
            }
            if (ObjectHelper.equal(remainder, "length")) {
                return FileExpressionBuilder.fileSizeExpression();
            }
            if (ObjectHelper.equal(remainder, "modified")) {
                return FileExpressionBuilder.fileLastModifiedExpression();
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date:", expression)) != null) {
            String[] parts = remainder.split(":");
            if (parts.length != 2) {
                throw new ExpressionIllegalSyntaxException("Valid syntax: ${date:command:pattern} was: " + expression);
            }
            String command = parts[0];
            String pattern = parts[1];
            return FileExpressionBuilder.dateExpression(command, pattern);
        }
        return SIMPLE.createSimpleExpression(expression, strict);
    }

    public boolean isSingleton() {
        return true;
    }
}

