/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="jaxb")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=false)
    private String contextPath;
    @XmlAttribute(required=false)
    private Boolean prettyPrint;
    @XmlAttribute(required=false)
    private Boolean ignoreJAXBElement;
    @XmlAttribute(required=false)
    private String encoding;

    public JaxbDataFormat() {
        super("jaxb");
    }

    public JaxbDataFormat(boolean prettyPrint) {
        this();
        this.setPrettyPrint(prettyPrint);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Boolean getIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(Boolean ignoreJAXBElement) {
        this.ignoreJAXBElement = ignoreJAXBElement;
    }

    protected void configureDataFormat(DataFormat dataFormat) {
        Boolean answer = ObjectHelper.toBoolean(this.getPrettyPrint());
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(dataFormat, "prettyPrint", Boolean.FALSE);
        } else {
            this.setProperty(dataFormat, "prettyPrint", Boolean.TRUE);
        }
        answer = ObjectHelper.toBoolean(this.getIgnoreJAXBElement());
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(dataFormat, "ignoreJAXBElement", Boolean.FALSE);
        } else {
            this.setProperty(dataFormat, "ignoreJAXBElement", Boolean.TRUE);
        }
        if (this.encoding != null) {
            this.setProperty(dataFormat, "encoding", this.encoding);
        }
        this.setProperty(dataFormat, "contextPath", this.contextPath);
    }
}

