/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ServiceHelper;

public abstract class RedeliveryErrorHandler
extends ErrorHandlerSupport
implements Processor {
    protected final Processor deadLetter;
    protected final String deadLetterUri;
    protected final Processor output;
    protected final Processor redeliveryProcessor;
    protected final RedeliveryPolicy redeliveryPolicy;
    protected final Predicate handledPolicy;
    protected final Logger logger;
    protected final boolean useOriginalMessagePolicy;

    public RedeliveryErrorHandler(Processor output, Logger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Predicate handledPolicy, Processor deadLetter, String deadLetterUri, boolean useOriginalMessagePolicy) {
        this.redeliveryProcessor = redeliveryProcessor;
        this.deadLetter = deadLetter;
        this.output = output;
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
        this.deadLetterUri = deadLetterUri;
        this.handledPolicy = handledPolicy;
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }

    public boolean supportTransacted() {
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.output == null) {
            return;
        }
        this.processErrorHandler(exchange, new RedeliveryData());
    }

    protected void processErrorHandler(Exchange exchange, RedeliveryData data) throws Exception {
        while (true) {
            boolean done;
            boolean shouldRedeliver;
            if (!this.isRunAllowed(exchange)) {
                return;
            }
            boolean handle = this.shouldHandleException(exchange);
            if (handle) {
                this.handleException(exchange, data);
            }
            if (!(shouldRedeliver = this.shouldRedeliver(exchange, data))) {
                Processor target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
                this.deliverToFailureProcessor(target, exchange, data);
                this.prepareExchangeAfterFailure(exchange, data);
                if (target != null) {
                    boolean deadLetterChannel = target == data.deadLetterProcessor && data.deadLetterProcessor != null;
                    EventHelper.notifyExchangeFailureHandled(exchange.getContext(), exchange, target, deadLetterChannel);
                }
                return;
            }
            if (shouldRedeliver && data.redeliveryCounter > 0) {
                this.prepareExchangeForRedelivery(exchange);
                try {
                    data.redeliveryDelay = data.currentRedeliveryPolicy.sleep(data.redeliveryDelay, data.redeliveryCounter);
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
                    continue;
                }
                if (!this.isRunAllowed(exchange)) {
                    return;
                }
                this.deliverToRedeliveryProcessor(exchange, data);
            }
            try {
                this.processExchange(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (done = this.isDone(exchange)) break;
        }
    }

    protected boolean isRunAllowed(Exchange exchange) {
        boolean stoppingCamel = false;
        CamelContext context = exchange.getContext();
        if (context instanceof ServiceSupport) {
            boolean bl = stoppingCamel = !((ServiceSupport)((Object)context)).isRunAllowed();
        }
        if (stoppingCamel || !this.isRunAllowed()) {
            if (this.log.isDebugEnabled()) {
                boolean stopping;
                boolean bl = stopping = this.isStopping() || this.isStopped();
                if (stopping) {
                    this.log.debug((Object)("Rejected execution as we are stopping for exchange: " + exchange));
                } else {
                    this.log.debug((Object)("Rejected execution as we are not started for exchange: " + exchange));
                }
            }
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException());
            }
            exchange.setProperty("CamelRouteStop", Boolean.TRUE);
            return false;
        }
        return true;
    }

    protected boolean shouldHandleException(Exchange exchange) {
        return exchange.getException() != null;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        this.output.process(exchange);
    }

    protected boolean isDone(Exchange exchange) throws Exception {
        return exchange.getException() == null || ExchangeHelper.isFailureHandled(exchange);
    }

    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public boolean isUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void prepareExchangeForRedelivery(Exchange exchange) {
        if (exchange.getException() != null) {
            exchange.setException(null);
        }
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache(exchange.getIn());
    }

    protected void handleException(Exchange exchange, RedeliveryData data) {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            data.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(exchange.getContext(), data.currentRedeliveryPolicy);
            data.handledPredicate = exceptionPolicy.getHandledPolicy();
            data.retryUntilPredicate = exceptionPolicy.getRetryUntilPolicy();
            data.useOriginalInMessage = exceptionPolicy.getUseOriginalMessagePolicy();
            Processor processor = exceptionPolicy.getErrorHandler();
            if (processor != null) {
                data.failureProcessor = processor;
            }
            if ((processor = exceptionPolicy.getOnRedelivery()) != null) {
                data.onRedeliveryProcessor = processor;
            }
        }
        String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId() + ". On delivery attempt: " + data.redeliveryCounter + " caught: " + e;
        this.logFailedDelivery(true, exchange, msg, data, e);
        data.redeliveryCounter = this.incrementRedeliveryCounter(exchange, e);
    }

    protected void deliverToRedeliveryProcessor(Exchange exchange, RedeliveryData data) {
        if (data.onRedeliveryProcessor == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Redelivery processor " + data.onRedeliveryProcessor + " is processing Exchange: " + exchange + " before its redelivered"));
        }
        try {
            data.onRedeliveryProcessor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        this.log.trace((Object)"Redelivery processor done");
    }

    protected void deliverToFailureProcessor(Processor processor, Exchange exchange, RedeliveryData data) {
        exchange.setException(null);
        if (data.handledPredicate != null && data.handledPredicate.matches(exchange)) {
            exchange.getIn().removeHeader("CamelRedelivered");
            exchange.getIn().removeHeader("CamelRedeliveryCounter");
        } else {
            this.decrementRedeliveryCounter(exchange);
        }
        MessageHelper.resetStreamCache(exchange.getIn());
        if (processor != null) {
            if (data.useOriginalInMessage) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Using the original IN message instead of current");
                }
                Message original = exchange.getUnitOfWork().getOriginalInMessage();
                exchange.setIn(original);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Failure processor " + processor + " is processing Exchange: " + exchange));
            }
            try {
                exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
                processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            this.log.trace((Object)"Failure processor done");
            String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId() + ". Processed by failure processor: " + processor;
            this.logFailedDelivery(false, exchange, msg, data, null);
        }
    }

    protected void prepareExchangeAfterFailure(Exchange exchange, RedeliveryData data) {
        boolean alreadySet;
        ExchangeHelper.setFailureHandled(exchange);
        boolean bl = alreadySet = exchange.getProperty("CamelErrorHandlerHandled") != null;
        if (alreadySet) {
            boolean handled = exchange.getProperty("CamelErrorHandlerHandled", Boolean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange has already been marked for handling: " + handled));
            }
            if (handled) {
                exchange.setException(null);
            } else {
                exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
                exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            }
            return;
        }
        Predicate handledPredicate = data.handledPredicate;
        if (handledPredicate == null || !handledPredicate.matches(exchange)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange is not handled so its marked as failed: " + exchange));
            }
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.FALSE);
            exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This exchange is handled so its marked as not failed: " + exchange));
            }
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.TRUE);
        }
    }

    private void logFailedDelivery(boolean shouldRedeliver, Exchange exchange, String message, RedeliveryData data, Throwable e) {
        if (this.logger == null) {
            return;
        }
        LoggingLevel newLogLevel = shouldRedeliver ? data.currentRedeliveryPolicy.getRetryAttemptedLogLevel() : data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
        if (exchange.isRollbackOnly()) {
            String msg = "Rollback exchange";
            if (exchange.getException() != null) {
                msg = msg + " due: " + exchange.getException().getMessage();
            }
            if (newLogLevel == LoggingLevel.ERROR || newLogLevel == LoggingLevel.FATAL) {
                this.logger.log(msg, LoggingLevel.WARN);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        } else if (data.currentRedeliveryPolicy.isLogStackTrace() && e != null) {
            this.logger.log(message, e, newLogLevel);
        } else {
            this.logger.log(message, newLogLevel);
        }
    }

    private boolean shouldRedeliver(Exchange exchange, RedeliveryData data) {
        Boolean rollback = exchange.getProperty("CamelRollbackOnly", Boolean.class);
        if (rollback != null && rollback.booleanValue()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This exchange is marked as rollback only, should not be redelivered: " + exchange));
            }
            return false;
        }
        return data.currentRedeliveryPolicy.shouldRedeliver(exchange, data.redeliveryCounter, data.retryUntilPredicate);
    }

    private int incrementRedeliveryCounter(Exchange exchange, Throwable e) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader("CamelRedeliveryCounter", next);
        in.setHeader("CamelRedelivered", Boolean.TRUE);
        return next;
    }

    private void decrementRedeliveryCounter(Exchange exchange) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        if (counter != null) {
            int prev = counter - 1;
            in.setHeader("CamelRedeliveryCounter", prev);
            in.setHeader("CamelRedelivered", prev > 0 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            in.setHeader("CamelRedeliveryCounter", 0);
            in.setHeader("CamelRedelivered", Boolean.FALSE);
        }
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.deadLetter);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.deadLetter, this.output);
    }

    protected class RedeliveryData {
        int redeliveryCounter;
        long redeliveryDelay;
        Predicate retryUntilPredicate;
        RedeliveryPolicy currentRedeliveryPolicy;
        Processor deadLetterProcessor;
        Processor failureProcessor;
        Processor onRedeliveryProcessor;
        Predicate handledPredicate;
        boolean useOriginalInMessage;

        protected RedeliveryData() {
            this.currentRedeliveryPolicy = RedeliveryErrorHandler.this.redeliveryPolicy;
            this.deadLetterProcessor = RedeliveryErrorHandler.this.deadLetter;
            this.onRedeliveryProcessor = RedeliveryErrorHandler.this.redeliveryProcessor;
            this.handledPredicate = RedeliveryErrorHandler.this.handledPolicy;
            this.useOriginalInMessage = RedeliveryErrorHandler.this.useOriginalMessagePolicy;
        }
    }
}

