/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PackageHelper {
    private static final transient Log LOG = LogFactory.getLog(PackageHelper.class);

    private PackageHelper() {
    }

    public static boolean isValidVersion(String packageName, double minimumVersion) {
        try {
            String value;
            Package spring = Package.getPackage(packageName);
            if (spring != null && (value = spring.getImplementationVersion()) != null) {
                double number;
                int idx = value.indexOf(46);
                if (idx >= 0) {
                    StringBuffer buffer = new StringBuffer(value.substring(0, ++idx));
                    int size = value.length();
                    for (int i = idx; i < size; ++i) {
                        char ch = value.charAt(i);
                        if (!Character.isDigit(ch)) continue;
                        buffer.append(ch);
                    }
                    value = buffer.toString();
                }
                return (number = Double.parseDouble(value)) >= minimumVersion;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to find out " + packageName + " version: " + e), (Throwable)e);
        }
        return true;
    }
}

