/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="weighted")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlAttribute(name="roundRobin", required=false)
    private Boolean roundRobin = Boolean.FALSE;
    @XmlAttribute(name="distributionRatio", required=true)
    private List<Integer> distributionRatioList = new ArrayList<Integer>();

    @Override
    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        WeightedLoadBalancer loadBalancer = null;
        try {
            loadBalancer = !this.roundRobin.booleanValue() ? new WeightedRandomLoadBalancer(this.distributionRatioList) : new WeightedRoundRobinLoadBalancer(this.distributionRatioList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadBalancer;
    }

    public Boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(Boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public List<Integer> getDistributionRatioList() {
        return this.distributionRatioList;
    }

    public void setDistributionRatioList(List<Integer> distributionRatioList) {
        this.distributionRatioList = distributionRatioList;
    }

    public String toString() {
        if (!this.roundRobin.booleanValue()) {
            return "WeightedRandomLoadBalancer[" + this.distributionRatioList + "]";
        }
        return "WeightedRoundRobinLoadBalancer[" + this.distributionRatioList + "]";
    }
}

