/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionPolicyStrategy
implements ExceptionPolicyStrategy {
    private static final transient Log LOG = LogFactory.getLog(DefaultExceptionPolicyStrategy.class);

    @Override
    public OnExceptionDefinition getExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies, Exchange exchange, Throwable exception) {
        TreeMap<Integer, OnExceptionDefinition> candidates = new TreeMap<Integer, OnExceptionDefinition>();
        boolean exactMatch = false;
        Iterator<Throwable> it = this.createExceptionIterator(exception);
        while (!exactMatch && it.hasNext()) {
            exactMatch = this.findMatchedExceptionPolicy(exceptionPolicies, exchange, it.next(), candidates);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found " + candidates.size() + " candidates"));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (OnExceptionDefinition)candidates.values().iterator().next();
    }

    private boolean findMatchedExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies, Exchange exchange, Throwable exception, Map<Integer, OnExceptionDefinition> candidates) {
        boolean exactMatch;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finding best suited exception policy for thrown exception " + exception.getClass().getName()));
        }
        int targetLevel = DefaultExceptionPolicyStrategy.getInheritanceLevel(exception.getClass());
        OnExceptionDefinition candidate = null;
        int candidateDiff = Integer.MAX_VALUE;
        Set<Map.Entry<ExceptionPolicyKey, OnExceptionDefinition>> entries = exceptionPolicies.entrySet();
        for (Map.Entry<ExceptionPolicyKey, OnExceptionDefinition> entry : entries) {
            Class<?> clazz = entry.getKey().getExceptionClass();
            OnExceptionDefinition type = entry.getValue();
            if (exchange != null && exchange.getUnitOfWork() != null) {
                RouteDefinition route = exchange.getUnitOfWork().getRouteContext() != null ? exchange.getUnitOfWork().getRouteContext().getRoute() : null;
                RouteDefinition typeRoute = ProcessorDefinitionHelper.getRoute(type);
                if (route != null && typeRoute != null && route != typeRoute) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("The type is scoped for route: " + typeRoute.getId() + " however Exchange is at route: " + route.getId()));
                    continue;
                }
            }
            if (!this.filter(type, clazz, exception)) continue;
            if (!this.matchesWhen(type, exchange)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("The type did not match when: " + type));
                continue;
            }
            if (clazz.equals(exception.getClass())) {
                candidate = type;
                candidateDiff = 0;
                break;
            }
            int level = DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz);
            int diff = targetLevel - level;
            if (diff >= candidateDiff) continue;
            candidate = type;
            candidateDiff = diff;
        }
        if (candidate != null) {
            if (!candidates.containsKey(candidateDiff)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Adding " + candidate + " as candidate at level " + candidateDiff));
                }
                candidates.put(candidateDiff, candidate);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Existing candidate " + candidates.get(candidateDiff) + " takes precedence over " + candidate + " at level " + candidateDiff));
            }
        }
        boolean bl = exactMatch = candidateDiff == 0;
        if (LOG.isTraceEnabled() && exactMatch) {
            LOG.trace((Object)("Exact match found for candidate: " + candidate));
        }
        return exactMatch;
    }

    protected boolean filter(OnExceptionDefinition type, Class<?> exceptionClass, Throwable exception) {
        return exceptionClass.isInstance(exception);
    }

    protected boolean matchesWhen(OnExceptionDefinition definition, Exchange exchange) {
        if (definition.getOnWhen() == null || definition.getOnWhen().getExpression() == null) {
            return true;
        }
        return definition.getOnWhen().getExpression().matches(exchange);
    }

    protected Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return ObjectHelper.createExceptionIterator(exception);
    }

    private static int getInheritanceLevel(Class<?> clazz) {
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return 0;
        }
        return 1 + DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz.getSuperclass());
    }
}

