/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadBalancerSupport
extends ServiceSupport
implements LoadBalancer,
Navigate<Processor> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final List<Processor> processors = new CopyOnWriteArrayList<Processor>();

    @Override
    public void addProcessor(Processor processor) {
        this.processors.add(processor);
    }

    @Override
    public void removeProcessor(Processor processor) {
        this.processors.remove(processor);
    }

    @Override
    public List<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors.size() > 0;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processors);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors);
        for (Processor processor : this.processors) {
            this.removeProcessor(processor);
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }
}

