#!/bin/bash

local_ref=$(git rev-parse --symbolic-full-name HEAD)
local_branch=${local_ref#refs/heads/}
local_cmid=$(git rev-parse HEAD)
remote_origin=$(git config branch.$local_branch.remote)
remote_ref=$(git config branch.$local_branch.merge)
remote_branch=$remote_origin/${remote_ref#refs/heads/}
remote_cmid=$(git rev-parse $remote_branch)

if ! git diff --quiet; then
    echo "You have uncommitted changes in your repo."
    echo "Please commit or revert those changes before building."
    echo "The following files are affected:"
    git diff --name-status
    exit 1
fi

if [ "$local_cmid" != "$remote_cmid" ]; then
    echo "You must push your local changes to the repo before building."
    echo "Local branch $local_branch is at commit: $local_cmid"
    echo "Remote branch $remote_branch is at commit: $remote_cmid"
    exit 1
fi

repo_id=$(brew taginfo mrg-messaging-3.2-win-build | awk -F: '/Current repo/ {print substr($2, index($2, "#") + 1)}')
echo "Build will use these dependencies:"
for pkg in boost-win qpid-cpp qpid-proton; do
    brew -q list-tagged --latest --inherit --repo $repo_id mrg-messaging-3.2-win-build $pkg | \
	grep -v Query | cut -d' ' -f1
done
echo

if [ "$1" == "--scratch" ]; then
    echo "Running scratch build..."
fi

#brew win-build --scratch mrg-messaging-3.2-win-candidate \
#     git://pkgs.devel.redhat.com/rpms/qpid-cpp-winsdk#$remote_cmid \
#     mrg-m-win2k8-vs2010-20110808-1

brew win-build $1 mrg-messaging-3.2-win-candidate \
     git://pkgs.devel.redhat.com/rpms/qpid-cpp-winsdk#$remote_cmid \
     mrg-m-win2k8-vs2010-20110808-1

