/**
 *  Copyright 2005-2015 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package org.jboss.arquillian.container.fabric8.common;

import io.fabric8.testkit.FabricController;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

import java.lang.annotation.Annotation;

/**
 * Injects the {@link FabricController} instances into test cases
 */
public class Fabric8ResourceProvider implements ResourceProvider {

    @Inject
    private Instance<FabricController> controller;

    @Override
    public boolean canProvide(Class<?> aClass) {
        return aClass.equals(FabricController.class);
    }

    @Override
    public Object lookup(ArquillianResource resource, Annotation... annotations) {
        return controller.get();
    }
}
