package org.jbosson.plugins.fuse;

import java.util.HashMap;

import org.junit.Assert;
import org.junit.Test;

/**
 * Test message formatting for mbeans
 */
public class FuseMBeanDiscoveryComponentTest extends Assert {

    @Test
    public void testFormatMessage() throws Exception {
        final HashMap<String, String> variableValues = new HashMap<String, String>();

        variableValues.put("a", "A");
        variableValues.put("b", "BB");
        final String longValue = new String(new char[FuseMBeanDiscoveryComponent.MAX_LENGTH]).replace("\0", "C");
        variableValues.put("c", longValue);

        // test with known values
        String message = FuseMBeanDiscoveryComponent.formatMessage("{a} {b} {c}", variableValues);
        assertEquals(500, message.length());
        assertEquals("A BB " + longValue.substring(5), message);

        // test with one unknown value, it should be assumed to larger than largest known value
        message = FuseMBeanDiscoveryComponent.formatMessage("{a} {b} {c} {d}", variableValues);
        assertEquals(256, message.length());
        assertEquals("A BB " + longValue.substring(253) + " {d}", message);
    }
}