## Example Programs

All example programs run from their respective source code directories with the command line *dotnet run*.
Examples can be executed by .NET Core 2.x or .NET Core 3.x run-time, using corresponding sub-directories:

   $ cd examples/netcoreapp2/HelloWorld-async
   $ dotnet run -- amqp://10.10.1.1:5672
or:
   $ cd examples/netcoreapp3/HelloWorld-async
   $ dotnet run -- amqp://10.10.1.1:5672

### Prerequisites

* A messaging broker with queue named *amq.topic* and with a queue named *service_queue* both with read/write permissions. For this illustration the broker was at IP address 10.10.1.1
* A messaging broker or Qpid Dispatch Router with source and target name *amq.topic* with suitable permissions. For this illustration the router was at IP address 10.10.2.2

### HelloWorld Simple

HelloWorld_simple is a simple example that creates a Sender and a Receiver for the same address, sends a message to the address, reads a message from the address, and prints the result.

#### HelloWorld_simple command line options

    Command line:
      dotnet run -- [brokerUrl [brokerEndpointAddress]]
    Default:
      dotnet run -- amqp://localhost:5672 amq.topic

#### HelloWorld_simple sample invocation

    $ dotnet run
    Hello world!

By default, this program connects to a broker running on
localhost:5672. Specify a host and port, and the 
AMQP endpoint address explicitly on the command line:

    $ dotnet run -- amqp://someotherhost.com:5672 endpointname

By default, this program addresses its messages to "amq.topic". In
some Amqp brokers amq.topic is a predefined endpoint address and is 
immediately available with no broker configuration. If this address
does not exist in the broker then use a broker management 
tool to create it.

### HelloWorld Robust

HelloWorld_robust shares all the features of the simple example with
additional options and processing:

* Accessing message properties beyond the simple payload:
 * Header
 * DeliveryAnnotations
 * MessageAnnotations
 * Properties
 * ApplicationProperties
 * BodySection
 * Footer
* Connection shutdown sequence

#### HelloWorld_robust command line options

    Command line:
      dotnet run -- [brokerUrl [brokerEndpointAddress [payloadText [enableTrace]]]]
    Default:
      dotnet run -- amqp://localhost:5672 amq.topic "Hello World"

#### HelloWorld_robust sample invocation

    $ dotnet run
    Broker: amqp://localhost:5672, Address: amq.topic, Payload: Hello World!
    body:Hello World!

HelloWorld_robust allows the user to specify a payload string and to 
enable trace protocol logging.

    $ dotnet run -- amqp://localhost:5672 amq.topic "My Hello" loggingOn

### HelloWorld Async

HelloWorld\_async is an example similar to HelloWorld\_simple except that it ses .Net *Task* and *async* methods.

HelloWorld\_simple is single threaded and uses blocking Amqp.Net Lite library methods. The blocking strategy works fine when exchanging messages with a messaging broker. The Sender and Receiver both attach to the broker. When the Sender sends a message then the broker settles the message and returns the settlement to the Sender. HelloWorld\_simple may then proceed to calling receive. The broker sends the message to the receiver and the receiver settles the message with the broker.

The blocking strategy will deadlock when exchanging messages in peer-to-peer
mode on a single connection to a Qpid Dispatch Router. In this case the
Sender sends the message to the router and the router does not settle the message.
Instead the router forwards the message to the Receiver and then waits for 
the Receiver to settle the message. In HelloWorld_simple the call to 
sender.Send deadlocks because it is waiting for the settlement to be returned
by the Receiver.

The async strategy solves this deadlock by running the Sender and Receiver on 
separate threads. In HelloWorld_async the sending process is able to block
and wait for the settlement on one thread while the receiving process is able
to receive and accept the message on another thread. After the receiver 
accepts the message the router forwards the accepted disposition to the sender.
The sender then returns successfully from the Send method.

#### HelloWorld_async command line options

    Command line:
      dotnet run -- [brokerUrl [brokerEndpointAddress]]
    Default:
      dotnet run -- amqp://localhost:5672 amq.topic

#### HelloWorld_async sample invocation

    $ dotnet run
    Hello world!

By default, this program connects to a broker running on
localhost:5672. Specify a host and port, and the 
AMQP endpoint address explicitly on the command line:

    $ dotnet run -- amqp://someotherhost.com:5672 endpointname

By default, this program addresses its messages to "amq.topic". In
some Amqp brokers amq.topic is a predefined endpoint address and is 
immediately available with no broker configuration. If this address
does not exist in the broker then use a broker management 
tool to create it.

### Interop.Drain.cs, Interop.Spout.cs (drain, spout)

Examples _Interop.Drain_ and _Interop.Spout_ illustrate interaction with a messaging broker or with
Qpid Dispatch Router. In this case there is no message broker. Instead the Qpid Dispatch Router
registers the addresses requested by the client programs and routes messages between
them.

#### Interop.Drain command line options

    $ dotnet run -- --help
     Usage: interop.drain [OPTIONS] --address STRING
     Create a connection, attach a receiver to an address, and receive messages.
 
    Options:
     --broker [amqp://guest:guest@127.0.0.1:5672] - AMQP 1.0 peer connection address
     --address STRING     []      - AMQP 1.0 terminus name
     --timeout SECONDS    [1]     - time to wait for each message to be received
     --forever            [false] - use infinite receive timeout
     --count INT          [1]     - receive this many messages and exit; 0 disables count based exit
     --initial-credit INT [10]    - receiver initial credit
     --reset-credit INT   [5]     - reset credit to initial-credit every reset-credit messages
     --quiet              [false] - do not print each message's content
     --help                       - print this message and exit
    
    Exit codes:
     0 - successfully received all messages
     1 - timeout waiting for a message
     2 - other error 

#### Interop.Spout command line options

    $ dotnet run -- --help
    Usage: Interop.Spout [OPTIONS] --address STRING
    Create a connection, attach a sender to an address, and send messages.
    
    Options:
     --broker [amqp://guest:guest@127.0.0.1:5672] - AMQP 1.0 peer connection address
     --address STRING  []      - AMQP 1.0 terminus name
     --timeout SECONDS [0]     - send for N seconds; 0 disables timeout
     --durable         [false] - send messages marked as durable
     --count INT       [1]     - send this many messages and exit; 0 disables count based exit
     --id STRING       [guid]  - message id
     --replyto STRING  []      - message ReplyTo address
     --content STRING  []      - message content
     --print           [false] - print each message's content
     --help                    - print this message and exit
 
 Exit codes:
  0 - successfully received all messages
  2 - other error
 
#### Interop.Spout and Interop.Drain sample invocation

In one window run Interop.drain. Drain waits
forever for one message to arrive.

    $ dotnet run -- --broker amqp://10.10.2.2:5672 --forever --count 1 --address amq.topic

In another window run Interop.spout. Spout sends a
message to the broker address and exits.

    $ dotnet run -- --broker amqp://10.10.2.2:5672 --address amq.topic
    $

Now in the first window drain will have received the message from spout and then exited.

    $ dotnet run -- --broker amqp://10.10.2.2:5672 --forever --count 1 --address amq.topic
    Message(Properties=properties(message-id:9803e781-14d3-4fa7-8e39-c65e18f3e8ea:0), ApplicationProperties=, Body=
    $

### Interop.Client, Interop.Server

This example shows a simple broker-based server that will accept strings from a
client, convert them to upper case, and send them back to the client. It has
two components:

* client - sends lines of poetry to the server and prints responses.
* server  - a simple service that will convert incoming strings to upper case and return them to the requester.

In this example the server and client share a service endpoint in the broker 
named *service_queue*.
The server listens for messages at the service endpoint. Clients create
temporary dynamic ReplyTo queues, embed the temporary name in the requests,
and send the requests to the server. After receiving and processing each 
request the server sends the reply to the client's temporary ReplyTo address.

#### Interop.Client command line options

    Command line:
      dotnet run -- [peerURI [loopcount]]
    Default:
      dotnet run -- amqp://guest:guest@localhost:5672 1

#### Interop.Server command line options

 Command line:
   dotnet run -- [peerURI]
 Default:
   dotnet run -- amqp://guest:guest@localhost:5672

#### Interop.Client, Interop.Server sample invocation

The programs may be launched with these command lines:

    $ dotnet run -- amqp://guest:guest@localhost:5672
    $ dotnet run -- amqp://guest:guest@localhost:5672

### PeerToPeer Examples

PeerToPeer.Server creates a listener on the address given in the command line.
This address initializes a _ContainerHost_ class object that listens for
incoming connections. Received messages are forwarded asynchronously to
a _RequestProcessor_ class object.

PeerToPeer.Client opens a connection to the server and starts sending
messages to the server.

#### PeerToPeer.Client command line options

    Command line:
      dotnet run -- [peerURI]
    Default:
      dotnet run -- amqp://guest:guest@localhost:5672

#### PeerToPeer.Server command line options

    Command line:
      dotnet run -- [peerURI]
    Default:
      dotnet run -- amqp://guest:guest@localhost:5672

#### PeerToPeer.Client, PeerToPeer.Server sample invocation

In one window run the PeerToPeer.Server

    $ dotnet run
    Container host is listening on 127.0.0.1:5672
    Request processor is registered on request_processor
    Press enter key to exist...
    Received a request hello 0
    ...
 
In another window run PeerToPeer.Client. PeerToPeer.Client sends messages
the the server and prints responses as they are received.

    $ dotnet run
    Running request client...
    Sent request properties(message-id:command-request,reply-to:client-57db8f65-6e3d-474c-a05e-8ca63b69d7c0) body hello 0
    Received response:  body reply0
    Received response:  body reply1
    ^C

### ReconnectSender Example

ReconnectSender illustrates starting a sender with a list of addresses
and connecting to them in recirculating order as connections fail.

This example also illustrates creating or recreating the hierarchy of 
sessions and links in response to asynchronous callback events. The code
follows the same path in response to the first connection to any server
as it follows for the Nth connection to any other server.

#### ReconnectSender command line options

    Command line:
      dotnet run -- [peerURI[,peerUri[,...]] [count]]
    Default:
      dotnet run -- amqp://127.0.0.1:5672/q1,amqp://127.0.0.1:15672/q1 10

#### ReconnectSender sample invocation

    $ dotnet run -- amqp://contoso.com/orders,amqp://10.10.10.10/orders 3
    [02:51:34.886] Attempting connection to  contoso.com:5672
    [02:51:44.920] Timeout waiting for connection
    [02:51:44.921] Entering Reconnect()
    [02:51:44.929] Attempting connection to  10.10.10.10:5672
    [02:51:45.282] Success: connecting to 10.10.10.10:5672
    [02:51:45.461] Event: OnOpened
    [02:51:45.629] Event: OnBegin
    [02:51:45.806] Event: OnAttached
    [02:51:45.807] Sending message 0
    [02:51:46.057] Sent    message 0
    [02:51:46.058] Sending message 1
    [02:51:46.244] Sent    message 1
    [02:51:46.245] Sending message 2
    [02:51:46.459] Sent    message 2
    >
