/*
Copyright 2019 The Interconnectedcloud Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	interconnectedcloudv1alpha1 "github.com/interconnectedcloud/qdr-operator/pkg/apis/interconnectedcloud/v1alpha1"
	versioned "github.com/interconnectedcloud/qdr-operator/pkg/client/clientset/versioned"
	internalinterfaces "github.com/interconnectedcloud/qdr-operator/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/interconnectedcloud/qdr-operator/pkg/client/listers/interconnectedcloud/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// InterconnectInformer provides access to a shared informer and lister for
// Interconnects.
type InterconnectInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.InterconnectLister
}

type interconnectInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewInterconnectInformer constructs a new informer for Interconnect type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewInterconnectInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredInterconnectInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredInterconnectInformer constructs a new informer for Interconnect type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredInterconnectInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.InterconnectedcloudV1alpha1().Interconnects(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.InterconnectedcloudV1alpha1().Interconnects(namespace).Watch(options)
			},
		},
		&interconnectedcloudv1alpha1.Interconnect{},
		resyncPeriod,
		indexers,
	)
}

func (f *interconnectInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredInterconnectInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *interconnectInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&interconnectedcloudv1alpha1.Interconnect{}, f.defaultInformer)
}

func (f *interconnectInformer) Lister() v1alpha1.InterconnectLister {
	return v1alpha1.NewInterconnectLister(f.Informer().GetIndexer())
}
