/*
 * Copyright Strimzi authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */
package io.strimzi.kafka.api.conversion.converter;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.strimzi.api.annotations.ApiVersion;

import static java.util.Arrays.asList;

/**
 * Use this converter for CR's that only need to change the version.
 *
 * @param <T> the actual custom resource type
 */
public abstract class AbstractVersionableConverter<T extends HasMetadata> extends Converter<T> {

    @SuppressWarnings("unchecked")
    public AbstractVersionableConverter() {
        super(asList(
            toVersionConversion(ApiVersion.V1ALPHA1, ApiVersion.V1BETA1),
            toVersionConversion(ApiVersion.V1BETA1, ApiVersion.V1BETA2)
        ));
    }
}
