/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.spi.graph.Name;
import org.jboss.dna.spi.graph.NameFactory;
import org.jboss.dna.spi.graph.NamespaceRegistry;
import org.jboss.dna.spi.graph.Path;
import org.jboss.dna.spi.sequencers.SequencerContext;
import org.jboss.dna.spi.sequencers.SequencerOutput;
import org.jboss.dna.spi.sequencers.StreamSequencer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlSequencer
implements StreamSequencer {
    static final Logger LOGGER = Logger.getLogger(XmlSequencer.class);
    static final String CDATA = "dnaxml:cData";
    static final String CDATA_CONTENT = "dnaxml:cDataContent";
    static final String COMMENT = "dnaxml:comment";
    static final String COMMENT_CONTENT = "dnaxml:commentContent";
    static final String DOCUMENT = "dnaxml:document";
    static final String DTD_NAME = "dnadtd:name";
    static final String DTD_PUBLIC_ID = "dnadtd:publicId";
    static final String DTD_SYSTEM_ID = "dnadtd:systemId";
    static final String DTD_VALUE = "dnadtd:value";
    static final String ELEMENT_CONTENT = "dnaxml:elementContent";
    static final String ENTITY = "dnadtd:entity";
    static final String PI = "dnaxml:processingInstruction";
    static final String PI_CONTENT = "dnaxml:processingInstructionContent";
    static final String TARGET = "dnaxml:target";
    private static final String DECL_HANDLER_FEATURE = "http://xml.org/sax/properties/declaration-handler";
    private static final String ENTITY_RESOLVER_2_FEATURE = "http://xml.org/sax/features/use-entity-resolver2";
    private static final String LEXICAL_HANDLER_FEATURE = "http://xml.org/sax/properties/lexical-handler";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequence(InputStream stream, SequencerOutput output, SequencerContext context, ProgressMonitor monitor) {
        monitor.beginTask(100.0, RepositoryI18n.sequencingXmlDocument, new Object[0]);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            Handler handler = new Handler(output, context, monitor);
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setProperty(DECL_HANDLER_FEATURE, handler);
            reader.setProperty(LEXICAL_HANDLER_FEATURE, handler);
            try {
                if (!reader.getFeature(ENTITY_RESOLVER_2_FEATURE)) {
                    reader.setFeature(ENTITY_RESOLVER_2_FEATURE, true);
                }
            }
            catch (SAXNotRecognizedException meansFeatureNotSupported) {
                // empty catch block
            }
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.parse(new InputSource(stream));
        }
        catch (Exception error) {
            LOGGER.error((Throwable)error, RepositoryI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
            monitor.getProblems().addError((Throwable)error, RepositoryI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
        }
        finally {
            monitor.done();
        }
    }

    private class IndexedName {
        Map<Name, List<IndexedName>> nameToIndexedNamesMap = new HashMap<Name, List<IndexedName>>();

        IndexedName() {
        }
    }

    private final class Handler
    extends DefaultHandler2 {
        private final SequencerOutput output;
        private final SequencerContext context;
        private final ProgressMonitor monitor;
        private double progress;
        private Path path;
        private final NameFactory nameFactory;
        private Name commentContentName;
        private Name commentName;
        private Name elementContentName;
        private Name primaryTypeName;
        private Name targetName;
        private Map<Name, List<IndexedName>> nameToIndexedNamesMap = new HashMap<Name, List<IndexedName>>();
        private final LinkedList<Map<Name, List<IndexedName>>> nameToIndexedNamesMapStack = new LinkedList();
        private final LinkedList<String> nsStack = new LinkedList();
        private StringBuilder cDataBuilder;
        private StringBuilder contentBuilder;
        private String entity;

        Handler(SequencerOutput output, SequencerContext context, ProgressMonitor monitor) {
            assert (output != null);
            assert (monitor != null);
            assert (context != null);
            this.output = output;
            this.context = context;
            this.monitor = monitor;
            this.path = context.getFactories().getPathFactory().createRelativePath();
            this.nameFactory = context.getFactories().getNameFactory();
        }

        public void attributeDecl(String name, String name2, String type, String mode, String value) throws SAXException {
            this.stopIfCancelled();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stopIfCancelled();
            String content = String.valueOf(ch, start, length);
            if (this.cDataBuilder == null) {
                if (this.entity != null) {
                    content = '&' + this.entity + ';';
                }
                if (this.contentBuilder == null) {
                    this.contentBuilder = new StringBuilder(content);
                } else {
                    if (this.entity == null) {
                        this.contentBuilder.append(' ');
                    }
                    this.contentBuilder.append(content);
                }
            } else {
                this.cDataBuilder.append(ch, start, length);
            }
            this.updateProgress();
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.stopIfCancelled();
            this.startElement(this.getCommentName());
            this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{this.getCommentName()});
            this.output.setProperty(this.path, this.getCommentContentName(), new Object[]{String.valueOf(ch, start, length)});
            this.endElement();
            this.updateProgress();
        }

        public void elementDecl(String name, String model) throws SAXException {
            this.stopIfCancelled();
        }

        public void endCDATA() throws SAXException {
            this.stopIfCancelled();
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.CDATA_CONTENT), new Object[]{this.cDataBuilder.toString()});
            this.endElement();
            this.cDataBuilder = null;
            this.updateProgress();
        }

        private void endContent() {
            if (this.contentBuilder != null) {
                String content = StringUtil.normalize((String)this.contentBuilder.toString());
                this.contentBuilder = null;
                if (content.length() > 0) {
                    this.startElement(this.getElementContentName());
                    this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{this.getElementContentName()});
                    this.output.setProperty(this.path, this.getElementContentName(), new Object[]{content});
                    this.endElement();
                }
            }
        }

        public void endDocument() throws SAXException {
            this.stopIfCancelled();
        }

        public void endDTD() throws SAXException {
            this.stopIfCancelled();
        }

        private void endElement() {
            this.path = this.path.getAncestor();
            this.nameToIndexedNamesMap.clear();
            this.nameToIndexedNamesMap = this.nameToIndexedNamesMapStack.removeFirst();
            this.nsStack.removeFirst();
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.stopIfCancelled();
            this.endContent();
            this.endElement();
            this.updateProgress();
        }

        public void endEntity(String name) throws SAXException {
            this.stopIfCancelled();
            this.entity = null;
            this.updateProgress();
        }

        public void error(SAXParseException error) {
            LOGGER.error((Throwable)error, RepositoryI18n.errorSequencingXmlDocument, new Object[]{error});
            this.monitor.getProblems().addError((Throwable)error, RepositoryI18n.errorSequencingXmlDocument, new Object[]{error});
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            this.stopIfCancelled();
            Name entityName = (Name)this.nameFactory.create(XmlSequencer.ENTITY);
            this.startElement(entityName);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{entityName});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_NAME), new Object[]{name});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_PUBLIC_ID), new Object[]{publicId});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_SYSTEM_ID), new Object[]{systemId});
            this.endElement();
            this.updateProgress();
        }

        public void fatalError(SAXParseException error) {
            LOGGER.error((Throwable)error, RepositoryI18n.fatalErrorSequencingXmlDocument, new Object[0]);
            this.monitor.getProblems().addError((Throwable)error, RepositoryI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
        }

        private Name getCommentContentName() {
            if (this.commentContentName == null) {
                this.commentContentName = (Name)this.nameFactory.create(XmlSequencer.COMMENT_CONTENT);
            }
            return this.commentContentName;
        }

        private Name getCommentName() {
            if (this.commentName == null) {
                this.commentName = (Name)this.nameFactory.create(XmlSequencer.COMMENT);
            }
            return this.commentName;
        }

        private Name getElementContentName() {
            if (this.elementContentName == null) {
                this.elementContentName = (Name)this.nameFactory.create(XmlSequencer.ELEMENT_CONTENT);
            }
            return this.elementContentName;
        }

        private Name getPrimaryTypeName() {
            if (this.primaryTypeName == null) {
                this.primaryTypeName = (Name)this.nameFactory.create("jcr:primaryType");
            }
            return this.primaryTypeName;
        }

        private Name getTargetName() {
            if (this.targetName == null) {
                this.targetName = (Name)this.nameFactory.create(XmlSequencer.TARGET);
            }
            return this.targetName;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.stopIfCancelled();
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
            this.stopIfCancelled();
            Name entityName = (Name)this.nameFactory.create(XmlSequencer.ENTITY);
            this.startElement(entityName);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{entityName});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_NAME), new Object[]{name});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_VALUE), new Object[]{value});
            this.endElement();
            this.updateProgress();
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.stopIfCancelled();
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.stopIfCancelled();
            Name name = (Name)this.nameFactory.create(XmlSequencer.PI);
            this.startElement(name);
            this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{name});
            this.output.setProperty(this.path, this.getTargetName(), new Object[]{target});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.PI_CONTENT), new Object[]{data});
            this.endElement();
            this.updateProgress();
        }

        public void skippedEntity(String name) throws SAXException {
            this.stopIfCancelled();
        }

        public void startCDATA() throws SAXException {
            this.stopIfCancelled();
            this.startElement((Name)this.nameFactory.create(XmlSequencer.CDATA));
            this.cDataBuilder = new StringBuilder();
            this.updateProgress();
        }

        public void startDocument() throws SAXException {
            this.stopIfCancelled();
            this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{this.nameFactory.create(XmlSequencer.DOCUMENT)});
            this.updateProgress();
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.stopIfCancelled();
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_NAME), new Object[]{name});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_PUBLIC_ID), new Object[]{publicId});
            this.output.setProperty(this.path, (Name)this.nameFactory.create(XmlSequencer.DTD_SYSTEM_ID), new Object[]{systemId});
            this.updateProgress();
        }

        private void startElement(Name name) {
            this.endContent();
            List<IndexedName> indexedNames = this.nameToIndexedNamesMap.get(name);
            if (indexedNames == null) {
                indexedNames = new ArrayList<IndexedName>();
                this.nameToIndexedNamesMap.put(name, indexedNames);
            }
            IndexedName indexedName = new IndexedName();
            indexedNames.add(indexedName);
            this.path = this.context.getFactories().getPathFactory().create(this.path, name, indexedNames.size());
            this.nameToIndexedNamesMapStack.addFirst(this.nameToIndexedNamesMap);
            this.nameToIndexedNamesMap = indexedName.nameToIndexedNamesMap;
            String ns = name.getNamespaceUri();
            if (ns.length() == 0) {
                this.nsStack.addFirst(this.nsStack.isEmpty() ? "" : this.nsStack.getFirst());
            } else {
                this.nsStack.addFirst(ns);
            }
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.stopIfCancelled();
            this.startElement((Name)this.nameFactory.create(name));
            this.output.setProperty(this.path, this.getPrimaryTypeName(), new Object[]{this.nameFactory.create(uri, localName)});
            String inheritedNs = this.nsStack.getFirst();
            int len = attributes.getLength();
            for (int ndx = 0; ndx < len; ++ndx) {
                String ns = attributes.getURI(ndx);
                this.output.setProperty(this.path, this.nameFactory.create(ns.length() == 0 ? inheritedNs : ns, attributes.getLocalName(ndx)), new Object[]{attributes.getValue(ndx)});
            }
            this.updateProgress();
        }

        public void startEntity(String name) throws SAXException {
            this.stopIfCancelled();
            this.entity = name;
            this.updateProgress();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.stopIfCancelled();
            NamespaceRegistry registry = this.context.getNamespaceRegistry();
            if (!registry.isRegisteredNamespaceUri(uri)) {
                registry.register(prefix, uri);
            }
            this.updateProgress();
        }

        private void stopIfCancelled() throws SAXException {
            if (this.monitor.isCancelled()) {
                throw new SAXException(RepositoryI18n.canceledSequencingXmlDocument.text(new Object[0]));
            }
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            this.stopIfCancelled();
        }

        private void updateProgress() {
            this.progress = this.progress == 100.0 ? 1.0 : (this.progress += 1.0);
            this.monitor.worked(this.progress);
        }

        public void warning(SAXParseException warning) {
            LOGGER.warn((Throwable)warning, RepositoryI18n.warningSequencingXmlDocument, new Object[0]);
            this.monitor.getProblems().addWarning((Throwable)warning, RepositoryI18n.warningSequencingXmlDocument, new Object[]{warning});
        }
    }
}

