/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.jboss.dna.common.util.CheckArg;

public class IoUtil {
    public static byte[] readBytes(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        boolean error = false;
        try {
            int numRead = 0;
            while ((numRead = stream.read(buffer)) > -1) {
                output.write(buffer, 0, numRead);
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block13: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (error) break block13;
                    throw e;
                }
            }
        }
        output.flush();
        return output.toByteArray();
    }

    public static byte[] readBytes(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        boolean error = false;
        try {
            byte[] byArray = IoUtil.readBytes(stream);
            return byArray;
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block11: {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    if (error) break block11;
                    throw e;
                }
            }
        }
    }

    public static String read(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        try {
            int numRead = 0;
            char[] buffer = new char[1024];
            while ((numRead = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, numRead);
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block13: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (error) break block13;
                    throw e;
                }
            }
        }
        return sb.toString();
    }

    public static String read(InputStream stream) throws IOException {
        return stream == null ? "" : IoUtil.read(new InputStreamReader(stream));
    }

    public static String read(File file) throws IOException {
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        FileReader reader = new FileReader(file);
        try {
            int numRead = 0;
            char[] buffer = new char[1024];
            while ((numRead = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, numRead);
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block13: {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    if (error) break block13;
                    throw e;
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(String content, OutputStream stream) throws IOException {
        CheckArg.isNotNull(stream, "destination stream");
        boolean error = false;
        try {
            if (content == null) return;
            byte[] bytes = content.getBytes();
            stream.write(bytes, 0, bytes.length);
            return;
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            try {
                stream.flush();
            }
            catch (IOException e) {
                if (!error) {
                    throw e;
                }
            }
            finally {
                block29: {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (error) break block29;
                        throw e;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(String content, Writer writer) throws IOException {
        CheckArg.isNotNull(writer, "destination writer");
        boolean error = false;
        try {
            if (content == null) return;
            writer.write(content);
            return;
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                if (!error) {
                    throw e;
                }
            }
            finally {
                block29: {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (error) break block29;
                        throw e;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(InputStream input, OutputStream stream) throws IOException {
        CheckArg.isNotNull(stream, "destination stream");
        boolean error = false;
        try {
            if (input == null) return;
            byte[] buffer = new byte[1024];
            try {
                int numRead = 0;
                while ((numRead = input.read(buffer)) > -1) {
                    stream.write(buffer, 0, numRead);
                }
                return;
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            try {
                stream.flush();
            }
            catch (IOException e) {
                if (!error) {
                    throw e;
                }
            }
            finally {
                block33: {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (error) break block33;
                        throw e;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(Reader input, Writer writer) throws IOException {
        CheckArg.isNotNull(writer, "destination writer");
        boolean error = false;
        try {
            if (input == null) return;
            char[] buffer = new char[1024];
            try {
                int numRead = 0;
                while ((numRead = input.read(buffer)) > -1) {
                    writer.write(buffer, 0, numRead);
                }
                return;
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                if (!error) {
                    throw e;
                }
            }
            finally {
                block33: {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (error) break block33;
                        throw e;
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isSame(InputStream input1, InputStream input2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IoUtil() {
    }
}

