/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ComponentConfig
implements Comparable<ComponentConfig> {
    private final String name;
    private final String description;
    private final String componentClassname;
    private final List<String> classpath;
    private final Map<String, Object> properties;
    private final long timestamp;

    public ComponentConfig(String name, String description, String classname, String ... classpath) {
        this(name, description, System.currentTimeMillis(), Collections.emptyMap(), classname, classpath);
    }

    public ComponentConfig(String name, String description, Map<String, Object> properties, String classname, String ... classpath) {
        this(name, description, System.currentTimeMillis(), properties, classname, classpath);
    }

    public ComponentConfig(String name, String description, long timestamp, Map<String, Object> properties, String classname, String ... classpath) {
        CheckArg.isNotEmpty(name, "name");
        this.name = name.trim();
        this.description = description != null ? description.trim() : "";
        this.componentClassname = classname;
        this.classpath = ComponentConfig.buildList(classpath);
        this.timestamp = timestamp;
        Map<Object, Object> map = this.properties = properties != null ? Collections.unmodifiableMap(new HashMap<String, Object>(properties)) : Collections.emptyMap();
        if (!ClassUtil.isFullyQualifiedClassname(classname)) {
            throw new IllegalArgumentException(CommonI18n.componentClassnameNotValid.text(classname, name));
        }
    }

    static List<String> buildList(String ... classpathElements) {
        List<String> classpath = null;
        if (classpathElements != null) {
            classpath = new ArrayList();
            for (String classpathElement : classpathElements) {
                if (classpath.contains(classpathElement)) continue;
                classpath.add(classpathElement);
            }
            classpath = Collections.unmodifiableList(classpath);
        } else {
            classpath = Collections.emptyList();
        }
        return classpath;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComponentClassname() {
        return this.componentClassname;
    }

    public List<String> getComponentClasspath() {
        return this.classpath;
    }

    public String[] getComponentClasspathArray() {
        return this.classpath.toArray(new String[this.classpath.size()]);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public int compareTo(ComponentConfig that) {
        if (that == this) {
            return 0;
        }
        int diff = this.getName().compareToIgnoreCase(that.getName());
        if (diff != 0) {
            return diff;
        }
        diff = (int)(this.getTimestamp() - that.getTimestamp());
        return diff;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ComponentConfig) {
            ComponentConfig that = (ComponentConfig)obj;
            if (!this.getClass().equals(that.getClass())) {
                return false;
            }
            return this.getName().equalsIgnoreCase(that.getName());
        }
        return false;
    }

    public boolean hasChanged(ComponentConfig component) {
        CheckArg.isNotNull(component, "component");
        CheckArg.isInstanceOf(component, this.getClass(), "component");
        if (!this.getName().equalsIgnoreCase(component.getName())) {
            return true;
        }
        if (!this.getDescription().equals(component.getDescription())) {
            return true;
        }
        if (!this.getComponentClassname().equals(component.getComponentClassname())) {
            return true;
        }
        return !((Object)this.getComponentClasspath()).equals(component.getComponentClasspath());
    }
}

