/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.math;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Random;
import org.jboss.dna.common.math.MathOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleOperations
implements MathOperations<Double>,
Comparator<Double> {
    @Override
    public Class<Double> getOperandClass() {
        return Double.class;
    }

    @Override
    public Double add(Double value1, Double value2) {
        if (value1 == null) {
            return value2 != null ? value2 : this.createZeroValue();
        }
        if (value2 == null) {
            return value1;
        }
        return value1 + value2;
    }

    @Override
    public Double subtract(Double value1, Double value2) {
        if (value1 == null) {
            return this.negate(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return value1 - value2;
    }

    @Override
    public Double multiply(Double value1, Double value2) {
        if (value1 == null || value2 == null) {
            return this.createZeroValue();
        }
        return value1 * value2;
    }

    @Override
    public double divide(Double value1, Double value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return value1 / value2;
    }

    @Override
    public Double negate(Double value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return value * -1.0;
    }

    @Override
    public Double increment(Double value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return value + 1.0;
    }

    @Override
    public Double maximum(Double value1, Double value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Math.max(value1, value2);
    }

    @Override
    public Double minimum(Double value1, Double value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Math.min(value1, value2);
    }

    @Override
    public int compare(Double value1, Double value2) {
        if (value1 == null) {
            return value2 != null ? -1 : 0;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    @Override
    public BigDecimal asBigDecimal(Double value) {
        return value != null ? new BigDecimal(value) : null;
    }

    @Override
    public Double fromBigDecimal(BigDecimal value) {
        return value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    @Override
    public Double createZeroValue() {
        return 0.0;
    }

    @Override
    public Double create(int value) {
        return value;
    }

    @Override
    public Double create(long value) {
        return value;
    }

    @Override
    public Double create(double value) {
        return value;
    }

    @Override
    public double sqrt(Double value) {
        return Math.sqrt(value);
    }

    @Override
    public Comparator<Double> getComparator() {
        return this;
    }

    @Override
    public Double random(Double minimum, Double maximum, Random rng) {
        Double difference = this.subtract(maximum, minimum);
        return minimum + difference * rng.nextDouble();
    }

    @Override
    public double doubleValue(Double value) {
        return value;
    }

    @Override
    public float floatValue(Double value) {
        return value.floatValue();
    }

    @Override
    public int intValue(Double value) {
        return value.intValue();
    }

    @Override
    public long longValue(Double value) {
        return value.longValue();
    }

    @Override
    public short shortValue(Double value) {
        return value.shortValue();
    }

    @Override
    public int getExponentInScientificNotation(Double value) {
        int exp;
        block3: {
            double v;
            block2: {
                v = Math.abs(value);
                exp = 0;
                if (!(v > 1.0)) break block2;
                while (v >= 10.0) {
                    v /= 10.0;
                    ++exp;
                }
                break block3;
            }
            if (v == 0.0 || !(v < 1.0)) break block3;
            while (v < 1.0) {
                v *= 10.0;
                --exp;
            }
        }
        return exp;
    }

    @Override
    public Double roundUp(Double value, int decimalShift) {
        if (value == 0.0) {
            return 0.0;
        }
        double shiftedValue = (Math.abs(value) * Math.pow(10.0, decimalShift) + 0.5) * Math.signum(value);
        double roundedValue = (int)shiftedValue;
        return roundedValue * Math.pow(10.0, -decimalShift);
    }

    @Override
    public Double roundDown(Double value, int decimalShift) {
        if (value == 0.0) {
            return 0.0;
        }
        double shiftedValue = Math.abs(value) * Math.pow(10.0, decimalShift) * Math.signum(value);
        double roundedValue = (int)shiftedValue;
        return roundedValue * Math.pow(10.0, -decimalShift);
    }

    @Override
    public Double keepSignificantFigures(Double value, int numSigFigs) {
        if (numSigFigs < 0) {
            return value;
        }
        if (numSigFigs == 0) {
            return 0.0;
        }
        int currentExp = this.getExponentInScientificNotation(value);
        int decimalShift = -currentExp + numSigFigs - 1;
        return this.roundUp(value, decimalShift);
    }
}

