/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.federation;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.federation.FederatedRepository;
import org.jboss.dna.repository.federation.FederatedRepositorySource;
import org.jboss.dna.repository.federation.FederationException;
import org.jboss.dna.repository.services.AbstractServiceAdministrator;
import org.jboss.dna.repository.services.AdministeredService;
import org.jboss.dna.repository.services.ServiceAdministrator;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.spi.graph.connection.RepositoryConnection;
import org.jboss.dna.spi.graph.connection.RepositorySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FederationService
implements AdministeredService {
    private final ClassLoaderFactory classLoaderFactory;
    private final ExecutionContext executionContext;
    private final RepositorySource configurationSource;
    private final Administrator administrator = new Administrator();
    private final ConcurrentMap<String, FederatedRepository> repositories = new ConcurrentHashMap<String, FederatedRepository>();
    private RepositoryConnection configurationConnection;

    public FederationService(RepositorySource configurationSource, ExecutionContext executionContext, ClassLoaderFactory classLoaderFactory) {
        ArgCheck.isNotNull((Object)configurationSource, (String)"configurationSource");
        ArgCheck.isNotNull((Object)executionContext, (String)"executionContext");
        this.configurationSource = configurationSource;
        this.executionContext = executionContext;
        this.classLoaderFactory = classLoaderFactory != null ? classLoaderFactory : new StandardClassLoaderFactory();
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public RepositorySource getConfigurationSource() {
        return this.configurationSource;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public String getJndiName() {
        return null;
    }

    protected synchronized void startService() {
        if (this.configurationConnection == null) {
            try {
                this.configurationConnection = this.configurationSource.getConnection();
            }
            catch (InterruptedException err) {
                I18n msg = RepositoryI18n.interruptedWhileConnectingToFederationConfigurationRepository;
                throw new FederationException(msg.text(new Object[]{this.configurationSource.getName()}));
            }
        }
    }

    protected FederatedRepository getRepository(String name) {
        FederatedRepository existingRepository;
        FederatedRepository repository = (FederatedRepository)this.repositories.get(name);
        if (repository == null && (existingRepository = this.repositories.putIfAbsent(name, repository = new FederatedRepository(this, name))) != null) {
            repository = existingRepository;
        }
        repository.getAdministrator().start();
        return repository;
    }

    protected synchronized void shutdownService() {
        if (this.configurationConnection != null) {
            try {
                this.configurationConnection.close();
            }
            catch (InterruptedException err) {
                throw new FederationException(RepositoryI18n.interruptedWhileClosingConnectionToFederationConfigurationRepository.text(new Object[]{this.configurationSource.getName()}));
            }
            for (String repositoryName : this.repositories.keySet()) {
                FederatedRepository repository = (FederatedRepository)this.repositories.get(repositoryName);
                repository.getAdministrator().shutdown();
            }
        }
    }

    protected boolean isTerminated() {
        for (String repositoryName : this.repositories.keySet()) {
            FederatedRepository repository = (FederatedRepository)this.repositories.get(repositoryName);
            if (repository.getAdministrator().isTerminated()) continue;
            return false;
        }
        return true;
    }

    protected boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        for (String repositoryName : this.repositories.keySet()) {
            FederatedRepository repository = (FederatedRepository)this.repositories.get(repositoryName);
            if (!repository.getAdministrator().awaitTermination(timeout, unit)) continue;
            return false;
        }
        return true;
    }

    public RepositorySource createRepositorySource(String repositoryName) {
        FederatedRepositorySource source = new FederatedRepositorySource(this, repositoryName);
        return source;
    }

    public Set<String> getRepositoryNames() {
        return Collections.unmodifiableSet(this.repositories.keySet());
    }

    protected void removeRepository(FederatedRepository repository) {
        this.repositories.remove(repository.getName(), repository);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            FederationService.this.startService();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
        }

        protected boolean doCheckIsTerminated() {
            return FederationService.this.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return FederationService.this.awaitTermination(timeout, unit);
        }
    }
}

