<?xml version="1.0"?>

<!-- 
	This is used to put add the modeshape policy into the login-config.xml on the server during EDS installation
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	<xsl:output method="xml" version="1.0" encoding="UTF-8"
		indent="yes"
	/>

	<xsl:template match="/policy">
		<policy>
      
      <xsl:for-each select="/policy/*">
        <xsl:if test="@name!='modeshape'">
 		<xsl:if test="@name!='ModeShapeEDSRepoDbRealm'">
              		<xsl:copy-of select="current()"/>
  		</xsl:if>
        </xsl:if>
      </xsl:for-each>
			
			<xsl:comment>EDS ModeShape REST/Webdav Security Domain</xsl:comment>
			 <application-policy xmlns="urn:jboss:security-beans:1.0" name="modeshape">
				<authentication>
					<login-module code="org.jboss.security.auth.spi.UsersRolesLoginModule" flag="required">
						<module-option name="unauthenticatedIdentity">guest</module-option>
						<!-- property files can found under conf/props directory -->
						<module-option name="usersProperties">props/users.properties</module-option>
						<module-option name="rolesProperties">props/roles.properties</module-option>
					</login-module>
				</authentication>
			</application-policy>  

			<xsl:comment>EDS ModeShape Repository Security Domain</xsl:comment>
   			<application-policy name="ModeShapeEDSRepoDbRealm">
      				<authentication>
         				<login-module code="org.jboss.resource.security.ConfiguredIdentityLoginModule" flag="required">
           					 <module-option name="principal">sa</module-option>
            					<module-option name="userName">sa</module-option>
            					<module-option name="password"/>
            					<module-option name="managedConnectionFactoryName">jboss.jca:service=LocalTxCM,name=ModeShapeEDSRepo</module-option>
         				</login-module>
      				</authentication>
   			</application-policy>
		</policy>

	</xsl:template>

	<xsl:template match="/">

		<xsl:apply-templates />
	</xsl:template>

</xsl:stylesheet>
