/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.io.Resource;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;

public class VerifierKnowledgeBaseBuilder {

    private List<VerifierError> errors = new ArrayList<VerifierError>();

    public KnowledgeBase newVerifierKnowledgeBase(VerifierConfiguration configuration) {

        KnowledgeBase verifierKnowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();

        KnowledgeBuilderConfiguration kbuilderConfiguration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbuilderConfiguration.setProperty( "drools.dialect.java.compiler",
                                           "JANINO" );

        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder( kbuilderConfiguration );

        if ( configuration.getVerifyingResources() != null ) {
            for ( Resource resource : configuration.getVerifyingResources().keySet() ) {
                kbuilder.add( resource,
                              configuration.getVerifyingResources().get( resource ) );
            }
        }

        if ( kbuilder.hasErrors() ) {
            Iterator<KnowledgeBuilderError> errors = kbuilder.getErrors().iterator();
            while ( errors.hasNext() ) {
                this.errors.add( new VerifierError( "Error compiling verifier rules: " + errors.next().getMessage() ) );
            }
        }

        verifierKnowledgeBase.addKnowledgePackages( kbuilder.getKnowledgePackages() );

        return verifierKnowledgeBase;
    }

    public List<VerifierError> getErrors() {
        return errors;
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }
}
