/*
 * Copyright 2011 JBoss Inc
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.drools.guvnor.client.decisiontable;

import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

/**
 * Interface defining commands relating to Condition Column operations
 */
public interface ConditionColumnCommand {

    /**
     * Causes the Command to perform its encapsulated behaviour.
     * 
     * @param pattern
     *            The pattern to which the column should be bound
     * @param column
     *            The column on which the command should operate
     */
    public void execute(Pattern52 pattern,
                        ConditionCol52 column);
}
