package org.jboss.brmsbpmsuite.patching.integrationtests;

import java.io.File;
import java.io.IOException;
import java.util.Collection;

import org.jboss.brmsbpmsuite.patching.integrationtests.model.distribution.Distribution;
import org.jboss.brmsbpmsuite.patching.integrationtests.model.distribution.DistributionException;
import org.jboss.brmsbpmsuite.patching.integrationtests.model.list.ProtectedList;
import org.jboss.brmsbpmsuite.patching.integrationtests.util.FileUtil;
import org.jboss.brmsbpmsuite.patching.integrationtests.util.WorkspaceUtil;
import org.junit.BeforeClass;

/**
 * Abstract class for tests that need to create only one test distribution that is shared between the test methods.
 * I.e. protectedlist tests.
 */
public abstract class AbstractOneDistributionForAllTestsIT extends AbstractIT {

    private static Distribution testingDistribution;
    private static Distribution testingPatchToolDistribution;

    private static ProtectedList protectedList;

    @BeforeClass
    public static void prepareTestDistribution() throws DistributionException, IOException {
        testingPatchToolDistribution = WorkspaceUtil.getNewPatchToolDistributionInstance(true);
        testingPatchToolDistribution.clean();
        testingPatchToolDistribution.create(getStartingPatchToolDistribution());

        protectedList = WorkspaceUtil.getProtectedlist(getStartingDistribution().getType());
        includeRandomFileInTheProtectedlist(getStartingDistribution());

        testingDistribution = WorkspaceUtil.getNewTestingDistributionInstance();
        testingDistribution.clean();
        testingDistribution.create(getStartingDistribution());
    }

    protected static Distribution getTestingDistribution() {
        return testingDistribution;
    }

    protected static Distribution getTestingPatchToolDistribution() {
        return testingPatchToolDistribution;
    }

    protected static ProtectedList getProtectedList() {
        return protectedList;
    }

    private static void includeRandomFileInTheProtectedlist(final Distribution distribution) throws DistributionException, IOException {
        boolean unpackedWars = false;
        try {
            unpackedWars = distribution.unpackWars();
            // Modify and include in the protectedlist some file. This file cannot be then overwritten and must have marker file created.
            final File fileFromChecksumList = findFileWithChecksum(distribution);
            if (fileFromChecksumList != null) {
                // File must also exist in patch, because otherwise it will be ignored during patching process.
                final File fileFromPatch = testingPatchToolDistribution.getFileFromOtherDistribution(fileFromChecksumList, distribution);
                if (fileFromPatch.exists()) {
                    FileUtil.appendTextToFile(fileFromChecksumList, "someText");
                    // It looks like that sometimes getAbsolutePath() returns path with / and sometimes not.
                    String relativePath = fileFromChecksumList.getAbsolutePath().replace(
                            distribution.getBundleRootDirectory().getAbsolutePath(), "");
                    if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
                        relativePath = relativePath.substring(1);
                    }
                    protectedList.appendTextToOriginalFile(relativePath);
                }
            }
        } finally {
            if (unpackedWars) {
                distribution.packWars();
            }
        }
    }

    private static File findFileWithChecksum(final Distribution distribution) {
        final Collection<String> filesWithChecksums = protectedList.getFilesThatHaveChecksum();
        for (String fileRelativePath : filesWithChecksums) {
            if (fileRelativePath.endsWith(".bat") || fileRelativePath.endsWith(".sh")
                    || fileRelativePath.endsWith(".xml") || fileRelativePath.endsWith(".conf")
                    || fileRelativePath.endsWith(".txt")) {
                final File file =
                        new File(distribution.getBundleRootDirectory().getAbsolutePath() + File.separator + fileRelativePath);
                if (file.exists()) {
                    return file;
                }
            }
        }
        return null;
    }
}