/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.dmn.client.api.dataobjects;

import java.util.List;
import java.util.function.Consumer;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.verify;

@RunWith(MockitoJUnitRunner.class)
public class DMNDataObjectsClientTest {

    @Mock
    private DMNClientServicesProxy proxy;

    private DMNDataObjectsClient client;

    @Before
    public void setup() {
        client = spy(new DMNDataObjectsClient(proxy));
    }

    @Test
    public void testLoadDataObjects() {

        final Consumer<List<DataObject>> consumer = mock(Consumer.class);

        final ServiceCallback serviceCallback = mock(ServiceCallback.class);

        doReturn(serviceCallback).when(client).callback(consumer);

        client.loadDataObjects(consumer);

        verify(proxy).loadDataObjects(serviceCallback);
    }
}