/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.adf.engine.backend.formGeneration;

import java.util.ResourceBundle;

import org.jboss.errai.bus.server.api.RpcContext;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.AbstractI18nHelper;
import org.kie.workbench.common.forms.adf.service.definitions.I18nSettings;

public class BackendI18nHelper extends AbstractI18nHelper {

    private ResourceBundle bundle;

    public BackendI18nHelper(I18nSettings settings) {
        super(settings);

        bundle = ResourceBundle.getBundle(settings.getBundle(),
                                          RpcContext.getServletRequest().getLocale());
    }

    @Override
    public String getTranslation(String key) {
        return bundle.getString(key);
    }
}
