/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import java.util.List;

import org.jboss.errai.common.client.api.IsElement;
import org.uberfire.commons.data.Pair;

public interface ConstructionHeuristicFormView extends IsElement {

    void setPresenter(ConstructionHeuristicForm presenter);

    void initConstructionHeuristicTypeSelectOptions(List<Pair<String, String>> options);

    void initEntitySorterMannerSelectOptions(List<Pair<String, String>> options);

    void setSelectedConstructionHeuristicType(String constructionHeuristicType);

    void setSelectedEntitySorterManner(String entitySorterManner);
}
