/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Producer;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.builder.FlowBuilderParameter;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.flow.builder.FlowBuilderImpl;
import org.apache.myfaces.flow.cdi.FlowBuilderCDIExtension;

@Named(value="oam_FLOW_BUILDER_FACTORY_BEAN_NAME")
@ApplicationScoped
public class FlowBuilderFactoryBean {
    public static final String FLOW_BUILDER_FACTORY_BEAN_NAME = "oam_FLOW_BUILDER_FACTORY_BEAN_NAME";
    private List<Flow> flowDefinitions = null;
    @Inject
    private FlowBuilderCDIExtension flowBuilderExtension;

    @Produces
    @FlowBuilderParameter
    public FlowBuilder createFlowBuilderInstance() {
        return new FlowBuilderImpl();
    }

    public List<Flow> getFlowDefinitions() {
        if (this.flowDefinitions == null) {
            this.flowDefinitions = new ArrayList<Flow>();
            BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
            Iterator<Producer<Flow>> it = this.flowBuilderExtension.getFlowProducers().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Flow flow = (Flow)it.next().produce(beanManager.createCreationalContext(null));
                    this.flowDefinitions.add(flow);
                }
            }
        }
        return this.flowDefinitions;
    }
}

