/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.faces.component.SelectItemsIterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class SelectItemsIterator
implements Iterator<SelectItem> {
    private Iterator<SelectItem> items;
    private ListIterator<UIComponent> kids;
    private SingleElementIterator singleItemIterator;
    private FacesContext ctx;

    public SelectItemsIterator(FacesContext ctx, UIComponent parent) {
        this.kids = parent.getChildren().listIterator();
        this.ctx = ctx;
    }

    @Override
    public boolean hasNext() {
        if (this.items != null) {
            if (this.items.hasNext()) {
                return true;
            }
            this.items = null;
        }
        Object next = this.findNextValidChild();
        while (next != null) {
            this.initializeItems(next);
            if (this.items != null) {
                return true;
            }
            next = this.findNextValidChild();
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.items != null) {
            return (SelectItem)this.items.next();
        }
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initializeItems(Object kid) {
        if (kid instanceof UISelectItem) {
            UISelectItem ui = (UISelectItem)kid;
            SelectItem item = (SelectItem)ui.getValue();
            if (item == null) {
                item = new SelectItem(ui.getItemValue(), ui.getItemLabel(), ui.getItemDescription(), ui.isItemDisabled(), ui.isItemEscaped(), ui.isNoSelectionOption());
            }
            this.updateSingeItemIterator(item);
            this.items = this.singleItemIterator;
        } else if (kid instanceof UISelectItems) {
            UISelectItems ui = (UISelectItems)kid;
            Object value = ui.getValue();
            if (value != null) {
                if (value instanceof SelectItem) {
                    this.updateSingeItemIterator((SelectItem)value);
                    this.items = this.singleItemIterator;
                } else if (value.getClass().isArray()) {
                    this.items = new ArrayIterator(this.ctx, (UISelectItems)kid, value, null);
                } else if (value instanceof Iterable) {
                    this.items = new IterableItemIterator(this.ctx, (UISelectItems)kid, (Iterable)value, null);
                } else if (value instanceof Map) {
                    this.items = new MapIterator((Map)value, null);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (this.items != null && !this.items.hasNext()) {
                this.items = null;
            }
        }
    }

    private Object findNextValidChild() {
        if (this.kids.hasNext()) {
            Object next = this.kids.next();
            while (this.kids.hasNext() && !(next instanceof UISelectItem) && !(next instanceof UISelectItems)) {
                next = this.kids.next();
            }
            if (next instanceof UISelectItem || next instanceof UISelectItems) {
                return next;
            }
        }
        return null;
    }

    private void updateSingeItemIterator(SelectItem item) {
        if (this.singleItemIterator == null) {
            this.singleItemIterator = new SingleElementIterator(null);
        }
        SingleElementIterator.access$400((SingleElementIterator)this.singleItemIterator, (SelectItem)item);
    }
}

