/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.MatteGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.MatteHeaderPainter;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class MistSilverSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Mist Silver";

    public MistSilverSkin() {
        SubstanceTheme activeTheme = new SubstanceTheme(new MetallicColorScheme(), "Tint Metallic", SubstanceTheme.ThemeKind.COLD).tint(0.1);
        SubstanceTheme defaultTheme = new SubstanceTheme(new MetallicColorScheme(), "Shade Metallic", SubstanceTheme.ThemeKind.COLD).shade(0.05);
        SubstanceTheme disabledTheme = defaultTheme.getDisabledTheme();
        SubstanceTheme activeTitleTheme = new SubstanceTheme(new ActiveTitleScheme(), "Silver Active Title", SubstanceTheme.ThemeKind.COLD);
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.setSelectedTabFadeStart(0.6);
        theme.setSelectedTabFadeEnd(1.0);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        this.theme = theme;
        this.shaper = new StandardButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new MatteGradientPainter();
        this.borderPainter = new ClassicBorderPainter();
        MatteHeaderPainter titlePainter = new MatteHeaderPainter();
        this.titlePainter = titlePainter;
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
    }

    public String getDisplayName() {
        return NAME;
    }

    protected static class ActiveTitleScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = new Color(197, 197, 197);
        private static final Color mainExtraLightColor = new Color(185, 185, 185);
        private static final Color mainLightColor = new Color(170, 170, 170);
        private static final Color mainMidColor = new Color(152, 152, 152);
        private static final Color mainDarkColor = new Color(152, 152, 152);
        private static final Color mainUltraDarkColor = new Color(152, 152, 152);
        private static final Color foregroundColor = Color.decode("#000000");

        protected ActiveTitleScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

