package com.redhat.installer.asconfiguration.ports.validator;


import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;

import java.util.List;
import java.util.ArrayList;
import java.util.HashSet;

/**
 * A validator template to check for port collisions in a configuration
 * <p/>
 * This validator can be extended and used on any custom ports panel
 *
 * @author Jyoti Tripathi, thauser
 */
public abstract class PortCollisionValidator implements DataValidator
{
    private static final String ERROR = "port.collision.check.template";
    String message = AutomatedInstallData.getInstance().langpack.getString(ERROR);
    private AutomatedInstallData idata;

    public Status validateData (AutomatedInstallData idata) {
        this.idata = idata;
        List<String> vars = new ArrayList<String>();
        vars.addAll(idata.getVariables().stringPropertyNames());
        String[] portVarNames  = vars.toArray(new String[0]);
        return findPortCollisions(portVarNames);
    }

    private Status findPortCollisions(String [] portVariableNames) {
        HashSet<Integer> ports         = new HashSet<Integer>();
        String serverConfig = getConfig();
        List<String> exclusions = getExclusions();
        List<String> inclusions = getInclusions();

        for (String portVariable : portVariableNames) {
            if (inclusions.contains(portVariable) || (portVariable.startsWith(serverConfig+".") && !portVariable.startsWith(serverConfig+".h.")
                    && !portVariable.startsWith(serverConfig+".f.") && !portVariable.startsWith(serverConfig+".fa.")
                    && !portVariable.endsWith("-2") && !portVariable.endsWith(".orig"))) {
                String value = idata.getVariable(portVariable);
                try {
                    if (!ports.add(PortUtils.getPort(value))) {
                        if (!exclusions.contains(portVariable) || Integer.parseInt(value) != 0) {
                            return Status.ERROR;
                        }
                    }
                } catch (Exception e){}
            }
        }
        return Status.OK;
    }


    public boolean getDefaultAnswer() {
        return true;
    }

    public String getWarningMessageId() {
        return null;
    }

    public String getErrorMessageId() {
        return ERROR;
    }

    public String getFormattedMessage() {
        return message;
    }

    protected abstract String getConfig();

    protected List<String> getExclusions() { return new ArrayList<String>(); }

    protected List<String> getInclusions() { return new ArrayList<String>(); }
}
