package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.dmr.ModelNode;

import java.util.ArrayList;
import java.util.List;

public class Ssl extends PostInstallation {
    /**
     * Passes the gathered IncludeSSL And LDAP information (keystore location and password) to
     * serverCommands. ServerCommands adds the IncludeSSLAndLDAP configuration to the
     * descriptor
     */

    private static final String DOMAIN_HTTPS_KEY = "domain.default.management-https-2";
    private static final String DOMAIN_HTTPS_VARIABLE_KEY = "domain.default.management-https-1";

    static boolean installSsl() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String keystore = idata.getVariable("ssl.path");
        String keystorePassword = idata.getVariable("ssl.password");
        boolean result;
        result = serverCommands.installSsl(keystore, keystorePassword, "ManagementRealm");
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.error"), true);
            return false;
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.success"), false);
        }
        if (arguments.length >= 2 && arguments[1].equals("host-slave")) {
            return true;
        }
        String port;
        if (serverCommands.isDomain()) {
            port = getDomainPortVariable();
        } else {
            port = null;
        }
        result = serverCommands.addHttps("ManagementRealm", port);
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.https.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ssl.https.success"), false);
        }
        return result;
    }

    static private String getDomainPortVariable() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return "${" + idata.getVariable(DOMAIN_HTTPS_VARIABLE_KEY) + ":" + idata.getVariable(DOMAIN_HTTPS_KEY) + "}";
    }

    @Override
    protected Class getClassName() {
        return Ssl.class;
    }

    @Override
    protected boolean performOperation() {
        return installSsl();
    }
}
