package com.redhat.installer.tests.installation.validator;


import com.izforge.izpack.Pack;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.util.OsConstraint;
import com.redhat.installer.framework.mock.MockFileBuilder;
import com.redhat.installer.framework.testers.ParameteredDataValidatorTester;
import com.redhat.installer.installation.validator.PathLengthValidator;
import com.redhat.installer.tests.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by thauser on 20/07/17.
 */
public class PathLengthValidatorTest extends ParameteredDataValidatorTester {
    @Before
    public void setUp() throws Exception {
        pdv = new PathLengthValidator();
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "pathvalidator.absolute.length.error", "pathvalidator.filename.length.error", "pathvalidator.reserved.name.error", "CharacterPathValidator.invalid");
        Map<String, String> params = new HashMap<>();
        params.put("packs", "test");
        params.put("variable", "pathtestvar");
        pdv.setParameters(params);

    }

    @Test
    public void testValidPath() throws Exception {
        idata.setVariable("pathtestvar", "/this/path/seems/fine/alaboooooo");
        idata.availablePacksMap = createPack("test", 20);
        assertStatusOk();
    }

    @Test
    public void testTooLongPath() throws Exception {
        idata.availablePacksMap = createPack("test", 500);
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        for (int i = 1; i < 4095 - 500; i++) {
            if (i % 230 == 0){
                sb.append("/");
            }
            sb.append("b");
        }
        idata.setVariable("pathtestvar", sb.toString());
        assertStatusError();
        assertLangpack("UserInputPanel.file.invalidfile.message");
    }

    @Test
    public void testNoMatchingPacks() throws Exception {
        idata.availablePacksMap = createPack("nomatch", 10);
        assertStatusError();
        assertLangpack("Invalid configuration in IzPack xmls.");
    }

    @Test
    public void testMultiplePacks() throws Exception {
        Map<String, String> params = new HashMap<>();
        idata.setVariable("pathtestvar", "/this/path/is/valid");
        params.put("packs", "test-0,test-1,test-2,test-3,test-4,test-5,test-6,test-7,test-8,test-9");
        params.put("variable", "pathtestvar");
        pdv.setParameters(params);
        idata.availablePacksMap = createMultiplePacks(10, 10);
        assert(idata.availablePacksMap.get("test-9").longestPath == 210);
        assertStatusOk();
    }

    private Map<String,Pack> createMultiplePacks(int numPacks, int fileLength) throws Exception{
        Map<String,Pack> packs = new HashMap<>();
        for (int i = 0; i < numPacks; i++){
            fileLength = fileLength+20;
            packs.putAll(createPack("test-"+i, fileLength));
        }
        return packs;
    }

    private Map<String,Pack> createPack(String id, int testLength) throws Exception {
        PackInfo test = new PackInfo("test pack", id, "whatever", true, false, "", true);
        StringBuilder sb = new StringBuilder();
        sb.append("${INSTALL_PATH}/");
        for (int i = 0; i < testLength - 1; i++) {
            sb.append("a");
        }
        File existingFile = MockFileBuilder.makeEmptyFile(tempFolder);
        test.addFile(tempFolder.getRoot(), existingFile, sb.toString(), new ArrayList<OsConstraint>(0), 0, new HashMap<String, String>(), "");
        Map<String, Pack> packMap = new HashMap<>();
        packMap.put(id, test.getPack());
        return packMap;
    }

    @After
    public void clearPacksAfterTest() {
        idata.availablePacks = null;
    }
}
