/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.library.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public class LibraryConstants {

    @TranslationKey(defaultValue = "")
    public static final String NewProject = "NewProject";

    @TranslationKey(defaultValue = "")
    public static final String ProjectCreated = "ProjectCreated";

    @TranslationKey(defaultValue = "")
    public static final String Settings = "Settings";

    @TranslationKey(defaultValue = "")
    public static final String ProjectImportedSuccessfully = "ProjectImportedSuccessfully";

    @TranslationKey(defaultValue = "")
    public static final String ProjectImportError = "ProjectImportError";

    @TranslationKey(defaultValue = "")
    public static final String Importing = "Importing";

    @TranslationKey(defaultValue = "")
    public static final String LoadingAssets = "LoadingAssets";

    @TranslationKey(defaultValue = "")
    public static final String LastModified = "LastModified";

    @TranslationKey(defaultValue = "")
    public static final String Created = "Created";

    @TranslationKey(defaultValue = "")
    public static final String DefaultProject = "DefaultProject";

    @TranslationKey(defaultValue = "")
    public static final String QuickSetup = "QuickSetup";

    @TranslationKey(defaultValue = "")
    public static final String AdvancedSetup = "AdvancedSetup";

    @TranslationKey(defaultValue = "")
    public static final String OtherProjects = "OtherProjects";

    @TranslationKey(defaultValue = "")
    public static final String ProjectDeleted = "ProjectDeleted";

    @TranslationKey(defaultValue = "")
    public static final String ABuildIsAlreadyRunning = "ABuildIsAlreadyRunning";

    @TranslationKey(defaultValue = "")
    public static final String FilterByName = "FilterByName";

    @TranslationKey(defaultValue = "")
    public static final String CreateOrganizationalUnit = "CreateOrganizationalUnit";

    @TranslationKey(defaultValue = "")
    public static final String Save = "Save";

    @TranslationKey(defaultValue = "")
    public static final String Cancel = "Cancel";

    @TranslationKey(defaultValue = "")
    public static final String DeleteOrganizationalUnitSuccess = "DeleteOrganizationalUnitSuccess";

    @TranslationKey(defaultValue = "")
    public static final String EmptyFieldValidation = "EmptyFieldValidation";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedOrganizationalUnitValidation = "DuplicatedOrganizationalUnitValidation";

    @TranslationKey(defaultValue = "")
    public static final String InvalidFieldValidation = "InvalidFieldValidation";

    @TranslationKey(defaultValue = "")
    public static final String Saving = "Saving";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitSaveSuccess = "OrganizationalUnitSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String Name = "Name";

    @TranslationKey(defaultValue = "")
    public static final String DefaultGroupId = "DefaultGroupId";

    @TranslationKey(defaultValue = "")
    public static final String Repositories = "Repositories";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitDefaultAliasInSingular = "OrganizationalUnitDefaultAliasInSingular";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitDefaultAliasInPlural = "OrganizationalUnitDefaultAliasInPlural";

    @TranslationKey(defaultValue = "")
    public static final String IndexingHasNotFinished = "IndexingHasNotFinished";

    @TranslationKey(defaultValue = "")
    public static final String PleaseWaitWhileTheProjectContentIsBeingIndexed = "PleaseWaitWhileTheProjectContentIsBeingIndexed";

    @TranslationKey(defaultValue = "")
    public static final String EmptySearch = "EmptySearch";

    @TranslationKey(defaultValue = "")
    public static final String NoFilesWhereFoundWithTheGivenSearchCriteria = "NoFilesWhereFoundWithTheGivenSearchCriteria";

    @TranslationKey(defaultValue = "")
    public static final String EndOfFileList = "EndOfFileList";

    @TranslationKey(defaultValue = "")
    public static final String NoMoreFilesPleasePressPrevious = "NoMoreFilesPleasePressPrevious";

    @TranslationKey(defaultValue = "")
    public static final String Preferences = "Preferences";

    @TranslationKey(defaultValue = "")
    public static final String AdvancedImport = "AdvancedImport";

    @TranslationKey(defaultValue = "")
    public static final String ImportProjects = "ImportProjects";

    @TranslationKey(defaultValue = "")
    public static final String ImportExamples = "ImportExamples";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedProjectValidation = "DuplicatedProjectValidation";

    @TranslationKey(defaultValue = "")
    public static final String OrgUnitsMetrics = "OrgUnitsMetrics";

    @TranslationKey(defaultValue = "")
    public static final String PerOrgUnit = "PerOrgUnit";

    @TranslationKey(defaultValue = "")
    public static final String ProjectMetrics = "ProjectMetrics";

    @TranslationKey(defaultValue = "")
    public static final String Metrics = "Metrics";

    @TranslationKey(defaultValue = "")
    public static final String Date = "Date";

    @TranslationKey(defaultValue = "")
    public static final String Years = "Years";

    @TranslationKey(defaultValue = "")
    public static final String Quarters = "Quarters";

    @TranslationKey(defaultValue = "")
    public static final String DayOfWeek = "DayOfWeek";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfCommits = "NumberOfCommits";

    @TranslationKey(defaultValue = "")
    public static final String Projects = "Projects";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfProjects = "NumberOfProjects";

    @TranslationKey(defaultValue = "")
    public static final String Project = "Project";

    @TranslationKey(defaultValue = "")
    public static final String Author = "Author";

    @TranslationKey(defaultValue = "")
    public static final String Message = "Message";

    @TranslationKey(defaultValue = "")
    public static final String TopContributor = "TopContributor";

    @TranslationKey(defaultValue = "")
    public static final String NotEnoughPermissionsToAccessLibrary = "NotEnoughPermissionsToAccessLibrary";

    @TranslationKey(defaultValue = "")
    public static final String Search = "Search";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfContributors = "NumberOfContributors";

    @TranslationKey(defaultValue = "")
    public static final String OrganizationalUnitView_NumberOfProjects = "OrganizationalUnitView.NumberOfProjects";

    @TranslationKey(defaultValue = "")
    public static final String NumberOfAssets = "NumberOfAssets";

    @TranslationKey(defaultValue = "")
    public static final String WrongOrganizationalUnitConfirmedName = "WrongOrganizationalUnitConfirmedName";

    @TranslationKey(defaultValue = "")
    public static final String DeletingOrganizationalUnit = "DeletingOrganizationalUnit";

    @TranslationKey(defaultValue = "")
    public static final String DeleteOrganizationalUnit = "DeleteOrganizationalUnit";

    @TranslationKey(defaultValue = "")
    public static final String DeleteOrganizationalUnitDescription = "DeleteOrganizationalUnitDescription";

    @TranslationKey(defaultValue = "")
    public static final String ConfirmOrganizationalUnitName = "ConfirmOrganizationalUnitName";

    @TranslationKey(defaultValue = "")
    public static final String EditOrganizationalUnitContributors = "EditOrganizationalUnitContributors";

    @TranslationKey(defaultValue = "")
    public static final String EditOrganizationalUnitContributorsSaveSuccess = "EditOrganizationalUnitContributorsSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String EditOrganizationalUnitContributorsRemoveSuccess = "EditOrganizationalUnitContributorsRemoveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String Add = "Add";

    @TranslationKey(defaultValue = "")
    public static final String AddProject = "AddProject";

    @TranslationKey(defaultValue = "")
    public static final String AddProjectSuccess = "AddProjectSuccess";

    @TranslationKey(defaultValue = "")
    public static final String ShowAdvancedOptions = "ShowAdvancedOptions";

    @TranslationKey(defaultValue = "")
    public static final String HideAdvancedOptions = "HideAdvancedOptions";

    @TranslationKey(defaultValue = "")
    public static final String GroupId = "GroupId";

    @TranslationKey(defaultValue = "")
    public static final String ArtifactId = "ArtifactId";

    @TranslationKey(defaultValue = "")
    public static final String Version = "Version";

    @TranslationKey(defaultValue = "")
    public static final String ImportProject = "ImportProject";

    @TranslationKey(defaultValue = "")
    public static final String Import = "Import";

    @TranslationKey(defaultValue = "")
    public static final String TrySamples = "TrySamples";

    @TranslationKey(defaultValue = "")
    public static final String Owner = "Owner";

    @TranslationKey(defaultValue = "")
    public static final String Contributor = "Contributor";

    @TranslationKey(defaultValue = "")
    public static final String NoProjectsToImport = "NoProjectsToImport";

    @TranslationKey(defaultValue = "")
    public static final String Loading = "Loading";

    @TranslationKey(defaultValue = "")
    public static final String NoProjectsSelected = "NoProjectsSelected";

    @TranslationKey(defaultValue = "")
    public static final String ImportProjectsSuccess = "ImportProjectsSuccess";

    @TranslationKey(defaultValue = "")
    public static final String NoOrganizationalUnits = "NoOrganizationalUnits";

    @TranslationKey(defaultValue = "")
    public static final String RepositoryURL = "RepositoryURL";

    @TranslationKey(defaultValue = "")
    public static final String DeleteProject = "DeleteProject";

    @TranslationKey(defaultValue = "")
    public static final String DeletingProject = "DeletingProject";

    @TranslationKey(defaultValue = "")
    public static final String WrongProjectConfirmedName = "WrongProjectConfirmedName";

    @TranslationKey(defaultValue = "")
    public static final String DeleteProjectDescription = "DeleteProjectDescription";

    @TranslationKey(defaultValue = "")
    public static final String ConfirmProjectName = "ConfirmProjectName";

    @TranslationKey(defaultValue = "")
    public static final String ImportAsset = "ImportAsset";

    @TranslationKey(defaultValue = "")
    public static final String AddAsset = "AddAsset";

    @TranslationKey(defaultValue = "")
    public static final String Renaming = "Renaming";

    @TranslationKey(defaultValue = "")
    public static final String Rename = "Rename";

    @TranslationKey(defaultValue = "")
    public static final String RenameSuccess = "RenameSuccess";

    @TranslationKey(defaultValue = "")
    public static final String ForkTitle = "ForkTitle";

    @TranslationKey(defaultValue = "")
    public static final String Fork = "Fork";

    @TranslationKey(defaultValue = "")
    public static final String ForkDescription = "ForkDescription";

    @TranslationKey(defaultValue = "")
    public static final String ALL = "ALL";

    @TranslationKey(defaultValue = "")
    public static final String Of = "Of";

    @TranslationKey(defaultValue = "")
    public static final String AllPackagesIncluded = "AllPackagesIncluded";

    @TranslationKey(defaultValue = "")
    public static final String PackagesNotIncluded = "PackagesNotIncluded";

    @TranslationKey(defaultValue = "")
    public static final String SomePackagesIncluded = "SomePackagesIncluded";

    @TranslationKey(defaultValue = "")
    public static final String SettingsSaveSuccess = "SettingsSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String SettingsLoadError = "SettingsLoadError";

    @TranslationKey(defaultValue = "")
    public static final String SettingsSectionSetupError = "SettingsSectionSetupError";

    @TranslationKey(defaultValue = "")
    public static final String PersistenceXmlConcurrentUpdate = "PersistenceXmlConcurrentUpdate";

    @TranslationKey(defaultValue = "")
    public static final String Class = "Class";

    @TranslationKey(defaultValue = "")
    public static final String AddPersistableDataObject = "AddPersistableDataObject";

    @TranslationKey(defaultValue = "")
    public static final String AddKnowledgeBase = "AddKnowledgeBase";

    @TranslationKey(defaultValue = "")
    public static final String Id = "Id";

    @TranslationKey(defaultValue = "")
    public static final String Role = "Role";

    @TranslationKey(defaultValue = "")
    public static final String AddIncludedKnowledgeBase = "AddIncludedKnowledgeBase";

    @TranslationKey(defaultValue = "")
    public static final String PackageName = "PackageName";

    @TranslationKey(defaultValue = "")
    public static final String AddPackage = "AddPackage";

    @TranslationKey(defaultValue = "")
    public static final String Value = "Value";

    @TranslationKey(defaultValue = "")
    public static final String AddProperty = "AddProperty";

    @TranslationKey(defaultValue = "")
    public static final String MigrationWasSuccessful = "MigrationWasSuccessful";

    @TranslationKey(defaultValue = "")
    public static final String ShowAuthenticationOptions = "ShowAuthenticationOptions";

    @TranslationKey(defaultValue = "")
    public static final String HideAuthenticationOptions = "HideAuthenticationOptions";

    @TranslationKey(defaultValue = "")
    public static final String PreferenceDisableGAVConflictCheck_Tooltip = "PreferenceDisableGAVConflictCheck.Tooltip";

    @TranslationKey(defaultValue = "")
    public static final String DevelopmentMode_Tooltip = "DevelopmentModeTooltip";

    @TranslationKey(defaultValue = "")
    public static final String ItemSuccessfullyDuplicated = "ItemSuccessfullyDuplicated";

    @TranslationKey(defaultValue = "")
    public static final String ReimportSuccessful = "ReimportSuccessful";

    @TranslationKey(defaultValue = "")
    public static final String CloseUnsavedProjectAssets = "CloseUnsavedProjectAssets";

    @TranslationKey(defaultValue = "")
    public static final String Proceed = "Proceed";

    @TranslationKey(defaultValue = "")
    public static final String CloseUnsavedProjectAssetsWarningMessage = "CloseUnsavedProjectAssetsWarningMessage";

    @TranslationKey(defaultValue = "")
    public static final String GitUrlSuccessfullyCopiedToClipboard = "GitUrlSuccessfullyCopiedToClipboard";

    @TranslationKey(defaultValue = "")
    public static final String GitUrlFailedToBeCopiedToClipboard = "GitUrlFailedToBeCopiedToClipboard";

    @TranslationKey(defaultValue = "")
    public static final String InvalidPom = "InvalidPom";

    @TranslationKey(defaultValue = "")
    public static final String Deployments = "Deployments";

    @TranslationKey(defaultValue = "")
    public static final String DeploymentsXmlConcurrentUpdate = "DeploymentsXmlConcurrentUpdate";

    @TranslationKey(defaultValue = "")
    public static final String AddMarshallingStrategy = "AddMarshallingStrategy";

    @TranslationKey(defaultValue = "")
    public static final String AddGlobal = "AddGlobal";

    @TranslationKey(defaultValue = "")
    public static final String AddEventListener = "AddEventListener";

    @TranslationKey(defaultValue = "")
    public static final String AddRequiredRole = "AddRequiredRole";

    @TranslationKey(defaultValue = "")
    public static final String AddRemoteableClass = "AddRemoteableClass";

    @TranslationKey(defaultValue = "")
    public static final String AddTaskEventListener = "AddTaskEventListener";

    @TranslationKey(defaultValue = "")
    public static final String AddConfiguration = "AddConfiguration";

    @TranslationKey(defaultValue = "")
    public static final String AddEnvironmentHandler = "AddEnvironmentHandler";

    @TranslationKey(defaultValue = "")
    public static final String AddWorkItemHandler = "AddWorkItemHandler";

    @TranslationKey(defaultValue = "")
    public static final String AddEnvironmentEntry = "AddEnvironmentEntry";

    @TranslationKey(defaultValue = "")
    public static final String ProjectScreenSettings = "ProjectScreenSettings";

    @TranslationKey(defaultValue = "")
    public static final String InvalidSpaceName = "InvalidSpaceName";

    @TranslationKey(defaultValue = "")
    public static final String InvalidProjectName = "InvalidProjectName";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedProjectName = "DuplicatedProjectName";

    @TranslationKey(defaultValue = "")
    public static final String AddBranch = "AddBranch";

    @TranslationKey(defaultValue = "")
    public static final String AddBranchSuccess = "AddBranchSuccess";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedBranchValidation = "DuplicatedBranchValidation";

    @TranslationKey(defaultValue = "")
    public static final String InvalidBranchName = "InvalidBranchName";

    @TranslationKey(defaultValue = "")
    public static final String DeleteBranchDescription = "DeleteBranchDescription";

    @TranslationKey(defaultValue = "")
    public static final String ConfirmBranchName = "ConfirmBranchName";

    @TranslationKey(defaultValue = "")
    public static final String WrongBranchConfirmedName = "WrongBranchConfirmedName";

    @TranslationKey(defaultValue = "")
    public static final String DeletingBranch = "DeletingBranch";

    @TranslationKey(defaultValue = "")
    public static final String DeleteBranch = "DeleteBranch";

    @TranslationKey(defaultValue = "")
    public static final String BranchDeleted = "BranchDeleted";

    @TranslationKey(defaultValue = "")
    public static final String InvalidUsername = "InvalidUsername";

    @TranslationKey(defaultValue = "")
    public static final String ContributorTypeOwner = "ContributorTypeOwner";

    @TranslationKey(defaultValue = "")
    public static final String ContributorTypeAdmin = "ContributorTypeAdmin";

    @TranslationKey(defaultValue = "")
    public static final String ContributorTypeContributor = "ContributorTypeContributor";

    @TranslationKey(defaultValue = "")
    public static final String SingleOwnerIsMandatory = "SingleOwnerIsMandatory";

    @TranslationKey(defaultValue = "")
    public static final String SpaceOwnerChanged = "SpaceOwnerChanged";

    @TranslationKey(defaultValue = "")
    public static final String DuplicatedContributor = "DuplicatedContributor";

    @TranslationKey(defaultValue = "")
    public static final String ContributorTypeNotAllowed = "ContributorTypeNotAllowed";
}
