CREATE FOREIGN PROCEDURE G1_GET(IN "$top" string NOT NULL OPTIONS (ANNOTATION 'Show only the first n items, see [OData Paging - Top](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptiontop)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$skip" string NOT NULL OPTIONS (ANNOTATION 'Skip the first n items, see [OData Paging - Skip](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionskip)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$search" string NOT NULL OPTIONS (ANNOTATION 'Search items by search phrases, see [OData Searching](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionsearch)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$filter" string NOT NULL OPTIONS (ANNOTATION 'Filter items by property values, see [OData Filtering](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionfilter)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$count" boolean NOT NULL OPTIONS (ANNOTATION 'Include count of items, see [OData Count](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptioncount)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$orderby" string[] NOT NULL OPTIONS (ANNOTATION 'Order items by property values, see [OData Sorting](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionorderby)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G1_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e1'), value_Loopy_1_VM1_G1_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e2'), value_Loopy_1_VM1_G1_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e3'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/FK0'), value_Loopy_1_VM1_G1_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/e1'), value_Loopy_1_VM1_G1_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e1'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e3'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Get entities from G1', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1');

CREATE FOREIGN PROCEDURE G1_POST(IN e1 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN e2 integer NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN e3 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN "G2_FK0_Loopy.1.VM1.G2-create_e1" string NOT NULL OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2-create/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN "G2_FK0_Loopy.1.VM1.G2-create_e2" integer NOT NULL OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2-create/e2', "teiid_rest:PARAMETER_TYPE" 'body'), IN "G2_FK0_Loopy.1.VM1.G2-create_FK0" string NOT NULL OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2-create/FK0', "teiid_rest:PARAMETER_TYPE" 'body'), IN G4_FKX_e1 string NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN G4_FKX_e2 integer NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/e2', "teiid_rest:PARAMETER_TYPE" 'body'), IN G4_FKX_FKX_e1 string NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN G4_FKX_FKX_e2 integer NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e2', "teiid_rest:PARAMETER_TYPE" 'body'), IN G4_FKX_FKX_e3 string NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e3', "teiid_rest:PARAMETER_TYPE" 'body'), IN "G4_FKX_FKX_G2_FK0_Loopy.1.VM1.G2-create_e1" string NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2-create/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN "G4_FKX_FKX_G2_FK0_Loopy.1.VM1.G2-create_e2" integer NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2-create/e2', "teiid_rest:PARAMETER_TYPE" 'body'), IN "G4_FKX_FKX_G2_FK0_Loopy.1.VM1.G2-create_FK0" string NOT NULL OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2-create/FK0', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (e1 string, e2 integer, e3 string, G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2/e1'), G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2/e2'), G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2/FK0'), G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'G4_FKX/e1'), G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'G4_FKX/e2'), G4_FKX_FKX_e1 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e1'), G4_FKX_FKX_e2 integer OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e2'), G4_FKX_FKX_e3 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e3'), G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Add new entity to G1', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1');

CREATE FOREIGN PROCEDURE "G1(e2)_GET"(IN e2 integer NOT NULL OPTIONS (ANNOTATION 'key: e2', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (e1 string, e2 integer, e3 string, G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2/e1'), G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2/e2'), G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'G2_FK0[]/Loopy.1.VM1.G2/FK0'), G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'G4_FKX/e1'), G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'G4_FKX/e2'), G4_FKX_FKX_e1 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e1'), G4_FKX_FKX_e2 integer OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e2'), G4_FKX_FKX_e3 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/e3'), G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Get entity from G1 by key', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1({e2})');

CREATE FOREIGN PROCEDURE "G1(e2)_DELETE"(IN e2 integer NOT NULL OPTIONS (ANNOTATION 'key: e2', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "If-Match" string NOT NULL OPTIONS (ANNOTATION 'ETag', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'header')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Delete entity from G1', "teiid_rest:METHOD" 'DELETE', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1({e2})');

CREATE FOREIGN PROCEDURE "G1(e2)_PATCH"(IN e2 integer NOT NULL OPTIONS (ANNOTATION 'key: e2', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN e1 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN e3 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Update entity in G1', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'PATCH', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1({e2})');

CREATE FOREIGN PROCEDURE "G1(e2)/G2_FK0_GET"(IN e2 integer NOT NULL OPTIONS (ANNOTATION 'key: e2', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$top" string NOT NULL OPTIONS (ANNOTATION 'Show only the first n items, see [OData Paging - Top](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptiontop)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$skip" string NOT NULL OPTIONS (ANNOTATION 'Skip the first n items, see [OData Paging - Skip](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionskip)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$search" string NOT NULL OPTIONS (ANNOTATION 'Search items by search phrases, see [OData Searching](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionsearch)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$filter" string NOT NULL OPTIONS (ANNOTATION 'Filter items by property values, see [OData Filtering](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionfilter)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$count" boolean NOT NULL OPTIONS (ANNOTATION 'Include count of items, see [OData Count](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptioncount)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$orderby" string[] NOT NULL OPTIONS (ANNOTATION 'Order items by property values, see [OData Sorting](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionorderby)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Get related G2', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1({e2})/G2_FK0');

CREATE FOREIGN PROCEDURE "G1(e2)/G2_FK0_POST"(IN e2 integer NOT NULL OPTIONS (ANNOTATION 'key: e2', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN e1 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN FK0 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (e1 string, e2 integer, FK0 string)
OPTIONS (ANNOTATION 'Add related G2', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1({e2})/G2_FK0');

CREATE FOREIGN PROCEDURE "G1(e2)/G4_FKX"(IN e2 integer NOT NULL OPTIONS (ANNOTATION 'key: e2', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G4_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/e1'), value_Loopy_1_VM1_G4_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/e2'), value_Loopy_1_VM1_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/e1'), value_Loopy_1_VM1_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/e2'), value_Loopy_1_VM1_G4_FKX_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/e3'), value_Loopy_1_VM1_G4_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G4_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G4_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'), value_Loopy_1_VM1_G4_FKX_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G4_FKX/e1'), value_Loopy_1_VM1_G4_FKX_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G4_FKX/e2'))
OPTIONS (ANNOTATION 'Get related G4', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G1({e2})/G4_FKX');

CREATE FOREIGN PROCEDURE G2_GET(IN "$top" string NOT NULL OPTIONS (ANNOTATION 'Show only the first n items, see [OData Paging - Top](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptiontop)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$skip" string NOT NULL OPTIONS (ANNOTATION 'Skip the first n items, see [OData Paging - Skip](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionskip)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$search" string NOT NULL OPTIONS (ANNOTATION 'Search items by search phrases, see [OData Searching](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionsearch)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$filter" string NOT NULL OPTIONS (ANNOTATION 'Filter items by property values, see [OData Filtering](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionfilter)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$count" boolean NOT NULL OPTIONS (ANNOTATION 'Include count of items, see [OData Count](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptioncount)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$orderby" string[] NOT NULL OPTIONS (ANNOTATION 'Order items by property values, see [OData Sorting](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionorderby)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Get entities from G2', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G2');

CREATE FOREIGN PROCEDURE G2_POST(IN e1 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN e2 integer NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN FK0 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (e1 string, e2 integer, FK0 string)
OPTIONS (ANNOTATION 'Add new entity to G2', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G2');

CREATE FOREIGN PROCEDURE "G2('e1')_GET"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (e1 string, e2 integer, FK0 string)
OPTIONS (ANNOTATION 'Get entity from G2 by key', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G2(''{e1}'')');

CREATE FOREIGN PROCEDURE "G2('e1')_DELETE"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "If-Match" string NOT NULL OPTIONS (ANNOTATION 'ETag', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'header')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Delete entity from G2', "teiid_rest:METHOD" 'DELETE', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G2(''{e1}'')');

CREATE FOREIGN PROCEDURE "G2('e1')_PATCH"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN e2 integer NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Update entity in G2', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'PATCH', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G2(''{e1}'')');

CREATE FOREIGN PROCEDURE "G2('e1')/FK0"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G1_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e1'), value_Loopy_1_VM1_G1_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e2'), value_Loopy_1_VM1_G1_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e3'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/FK0'), value_Loopy_1_VM1_G1_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/e1'), value_Loopy_1_VM1_G1_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e1'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e3'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Get related G1', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G2(''{e1}'')/FK0');

CREATE FOREIGN PROCEDURE G4_GET(IN "$top" string NOT NULL OPTIONS (ANNOTATION 'Show only the first n items, see [OData Paging - Top](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptiontop)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$skip" string NOT NULL OPTIONS (ANNOTATION 'Skip the first n items, see [OData Paging - Skip](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionskip)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$search" string NOT NULL OPTIONS (ANNOTATION 'Search items by search phrases, see [OData Searching](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionsearch)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$filter" string NOT NULL OPTIONS (ANNOTATION 'Filter items by property values, see [OData Filtering](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionfilter)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$count" boolean NOT NULL OPTIONS (ANNOTATION 'Include count of items, see [OData Count](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptioncount)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$orderby" string[] NOT NULL OPTIONS (ANNOTATION 'Order items by property values, see [OData Sorting](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionorderby)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G4_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/e1'), value_Loopy_1_VM1_G4_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/e2'), value_Loopy_1_VM1_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/e1'), value_Loopy_1_VM1_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/e2'), value_Loopy_1_VM1_G4_FKX_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/e3'), value_Loopy_1_VM1_G4_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G4_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G4_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'), value_Loopy_1_VM1_G4_FKX_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G4_FKX/e1'), value_Loopy_1_VM1_G4_FKX_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G4/FKX/G4_FKX/e2'))
OPTIONS (ANNOTATION 'Get entities from G4', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G4');

CREATE FOREIGN PROCEDURE G4_POST(IN e1 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN e2 integer NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN FKX_e1 string NOT NULL OPTIONS (NAMEINSOURCE 'FKX/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN FKX_e2 integer NOT NULL OPTIONS (NAMEINSOURCE 'FKX/e2', "teiid_rest:PARAMETER_TYPE" 'body'), IN FKX_e3 string NOT NULL OPTIONS (NAMEINSOURCE 'FKX/e3', "teiid_rest:PARAMETER_TYPE" 'body'), IN "FKX_G2_FK0_Loopy.1.VM1.G2-create_e1" string NOT NULL OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2-create/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN "FKX_G2_FK0_Loopy.1.VM1.G2-create_e2" integer NOT NULL OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2-create/e2', "teiid_rest:PARAMETER_TYPE" 'body'), IN "FKX_G2_FK0_Loopy.1.VM1.G2-create_FK0" string NOT NULL OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2-create/FK0', "teiid_rest:PARAMETER_TYPE" 'body'), IN FKX_G4_FKX_e1 string NOT NULL OPTIONS (NAMEINSOURCE 'FKX/G4_FKX/e1', "teiid_rest:PARAMETER_TYPE" 'body'), IN FKX_G4_FKX_e2 integer NOT NULL OPTIONS (NAMEINSOURCE 'FKX/G4_FKX/e2', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (e1 string, e2 integer, FKX_e1 string OPTIONS (NAMEINSOURCE 'FKX/e1'), FKX_e2 integer OPTIONS (NAMEINSOURCE 'FKX/e2'), FKX_e3 string OPTIONS (NAMEINSOURCE 'FKX/e3'), FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'), FKX_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'FKX/G4_FKX/e1'), FKX_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'FKX/G4_FKX/e2'))
OPTIONS (ANNOTATION 'Add new entity to G4', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G4');

CREATE FOREIGN PROCEDURE "G4('e1')_GET"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (e1 string, e2 integer, FKX_e1 string OPTIONS (NAMEINSOURCE 'FKX/e1'), FKX_e2 integer OPTIONS (NAMEINSOURCE 'FKX/e2'), FKX_e3 string OPTIONS (NAMEINSOURCE 'FKX/e3'), FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'), FKX_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'FKX/G4_FKX/e1'), FKX_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'FKX/G4_FKX/e2'))
OPTIONS (ANNOTATION 'Get entity from G4 by key', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G4(''{e1}'')');

CREATE FOREIGN PROCEDURE "G4('e1')_DELETE"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "If-Match" string NOT NULL OPTIONS (ANNOTATION 'ETag', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'header')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Delete entity from G4', "teiid_rest:METHOD" 'DELETE', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G4(''{e1}'')');

CREATE FOREIGN PROCEDURE "G4('e1')_PATCH"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN e2 integer NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Update entity in G4', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'PATCH', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G4(''{e1}'')');

CREATE FOREIGN PROCEDURE "G4('e1')/FKX"(IN e1 string NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$expand" string[] NOT NULL OPTIONS (ANNOTATION 'Expand related entities, see [OData Expand](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionexpand)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_G1_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e1'), value_Loopy_1_VM1_G1_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e2'), value_Loopy_1_VM1_G1_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/e3'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G1_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G2_FK0[]/Loopy.1.VM1.G2/FK0'), value_Loopy_1_VM1_G1_G4_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/e1'), value_Loopy_1_VM1_G1_G4_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e1'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_e3 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/e3'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e1 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e1'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_e2 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/e2'), value_Loopy_1_VM1_G1_G4_FKX_FKX_G2_FK0_Loopy_1_VM1_G2_FK0 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.G1/G4_FKX/FKX/G2_FK0[]/Loopy.1.VM1.G2/FK0'))
OPTIONS (ANNOTATION 'Get related G1', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/G4(''{e1}'')/FKX');

CREATE FOREIGN PROCEDURE LobTable_GET(IN "$top" string NOT NULL OPTIONS (ANNOTATION 'Show only the first n items, see [OData Paging - Top](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptiontop)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$skip" string NOT NULL OPTIONS (ANNOTATION 'Skip the first n items, see [OData Paging - Skip](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionskip)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$search" string NOT NULL OPTIONS (ANNOTATION 'Search items by search phrases, see [OData Searching](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionsearch)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$filter" string NOT NULL OPTIONS (ANNOTATION 'Filter items by property values, see [OData Filtering](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionfilter)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$count" boolean NOT NULL OPTIONS (ANNOTATION 'Include count of items, see [OData Count](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptioncount)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$orderby" string[] NOT NULL OPTIONS (ANNOTATION 'Order items by property values, see [OData Sorting](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionorderby)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (value_Loopy_1_VM1_LobTable_e1 integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.LobTable/e1'), value_Loopy_1_VM1_LobTable_e2 string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.LobTable/e2'))
OPTIONS (ANNOTATION 'Get entities from LobTable', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/LobTable');

CREATE FOREIGN PROCEDURE LobTable_POST(IN e1 integer NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body'), IN e2 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (e1 integer, e2 string)
OPTIONS (ANNOTATION 'Add new entity to LobTable', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/LobTable');

CREATE FOREIGN PROCEDURE "LobTable(e1)_GET"(IN e1 integer NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "$select" string[] NOT NULL OPTIONS (ANNOTATION 'Select properties to be returned, see [OData Select](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_SystemQueryOptionselect)', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'form', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (e1 integer, e2 string)
OPTIONS (ANNOTATION 'Get entity from LobTable by key', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/LobTable({e1})');

CREATE FOREIGN PROCEDURE "LobTable(e1)_DELETE"(IN e1 integer NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN "If-Match" string NOT NULL OPTIONS (ANNOTATION 'ETag', "teiid_rel:default_handling" 'omit', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'header')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Delete entity from LobTable', "teiid_rest:METHOD" 'DELETE', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/LobTable({e1})');

CREATE FOREIGN PROCEDURE "LobTable(e1)_PATCH"(IN e1 integer NOT NULL OPTIONS (ANNOTATION 'key: e1', "teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN e2 string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Update entity in LobTable', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'PATCH', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/LobTable({e1})');

CREATE FOREIGN PROCEDURE actionXML(OUT "return" string RESULT, IN x string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Invoke action actionXML', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/actionXML');

CREATE FOREIGN PROCEDURE procActionJSON(OUT "return" string RESULT, IN x string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN y string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Invoke action procActionJSON', "teiid_rest:CONSUMES" 'application/json', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/procActionJSON');

CREATE FOREIGN PROCEDURE "getCustomerIds(p1=p1)"(IN p1 integer NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE ("value" integer[])
OPTIONS (ANNOTATION 'Invoke function getCustomerIds', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/getCustomerIds(p1={p1})');

CREATE FOREIGN PROCEDURE "getCustomers(p2=p2,p3='p3')"(OUT "return" timestamp RESULT, IN p2 timestamp NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN p3 string NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Invoke function getCustomers', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/getCustomers(p2={p2},p3=''{p3}'')');

CREATE FOREIGN PROCEDURE "proc(x='x')"(OUT "return" string RESULT, IN x string NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Invoke function proc', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/proc(x=''{x}'')');

CREATE FOREIGN PROCEDURE "procResultSet(x='x',y=y)"(IN x string NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path'), IN y integer NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (value_Loopy_1_VM1_procResultSet_RSParam_x string OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.procResultSet_RSParam/x'), value_Loopy_1_VM1_procResultSet_RSParam_y integer OPTIONS (NAMEINSOURCE 'value[]/Loopy.1.VM1.procResultSet_RSParam/y'))
OPTIONS (ANNOTATION 'Invoke function procResultSet', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/procResultSet(x=''{x}'',y={y})');

CREATE FOREIGN PROCEDURE "procXML(x='x')"(OUT "return" string RESULT, IN x string NOT NULL OPTIONS ("teiid_rest:COLLECION_FORMAT" 'simple', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Invoke function procXML', "teiid_rest:METHOD" 'GET', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/procXML(x=''{x}'')');

CREATE FOREIGN PROCEDURE "$batch"(OUT "return" string RESULT, IN body clob NOT NULL OPTIONS (ANNOTATION 'Batch request', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (error_code string OPTIONS (NAMEINSOURCE 'error/code'), error_message string OPTIONS (NAMEINSOURCE 'error/message'), error_target string OPTIONS (NAMEINSOURCE 'error/target'), error_details_odata_error_detail_code string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/code'), error_details_odata_error_detail_message string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/message'), error_details_odata_error_detail_target string OPTIONS (NAMEINSOURCE 'error/details[]/odata.error.detail/target'))
OPTIONS (ANNOTATION 'Group multiple requests into a single request payload, see [OData Batch Requests](http://docs.oasis-open.org/odata/odata/v4.01/odata-v4.01-part1-protocol.html#sec_BatchRequests).\u000A\u000A*Please note that "Try it out" is not supported for this request.*', "teiid_rest:CONSUMES" 'multipart/mixed;boundary=request-separator', "teiid_rest:METHOD" 'POST', "teiid_rest:PRODUCES" 'application/json', "teiid_rest:URI" '${host}/odata4/loopy/vm1/$batch');