/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client;

import com.ibm.wssvt.acme.common.adapter.IServerAdapterEventListener;
import com.ibm.wssvt.acme.common.client.IExecutionUnitRunner;
import com.ibm.wssvt.acme.common.client.IExecutionUnitRunnerMonitor;
import com.ibm.wssvt.acme.common.client.IReportedMessageVisitor;
import com.ibm.wssvt.acme.common.envconfig.ClientConfiguration;
import com.ibm.wssvt.acme.common.envconfig.IApplicationEnvConfig;
import com.ibm.wssvt.acme.common.envconfig.exception.ConfigurationException;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnitEventListener;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnitStack;
import com.ibm.wssvt.acme.common.executionunit.ISingleRunExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.IStackableExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLoggerConfig;
import com.ibm.wssvt.acme.common.log.AcmeLoggerFactory;
import com.ibm.wssvt.acme.common.stats.ExecutionStats;
import com.ibm.wssvt.acme.common.stats.ExecutionStatsFormatter;
import com.ibm.wssvt.acme.common.stats.ExecutionStatus;
import com.ibm.wssvt.acme.common.stats.IExecutionStatsFormatter;
import com.ibm.wssvt.acme.common.util.ClientContext;
import com.ibm.wssvt.acme.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionUnitRunner
extends Thread
implements IExecutionUnitRunner,
IReportedMessageVisitor {
    private static final String PRINT_STATS_INVTERVAL = "print.stats.interval";
    private long threadLoopCounter;
    private Date endTime = new Date(System.currentTimeMillis() + 1L);
    private List<IExecutionUnit> executionUnits;
    private List<IExecutionUnitStack> executionUnitStacks;
    private boolean suspendThread = false;
    private Logger logger;
    private ClientConfiguration clientConfiguration;
    private ClientContext clientContext;
    private List<IServerAdapterEventListener> serverAdapterEventListenerList;
    private List<IExecutionUnitEventListener> executionUnitEventListenerList;
    private IExecutionUnitRunnerMonitor executionUnitRunnerMonitor;
    private String reportedMessage;
    private IReportedMessageVisitor reportedMessageVisitor;
    private IExecutionStatsFormatter statsFormatter;

    public ExecutionUnitRunner(IApplicationEnvConfig applicationEnvConfig, ClientContext ctx, IExecutionUnitRunnerMonitor executionUnitRunnerMonitor, List<IExecutionUnitEventListener> executionUnitEventListenerList, List<IServerAdapterEventListener> serverAdapterEventListenerList, IReportedMessageVisitor reportedMessageVisitor, IExecutionStatsFormatter executionStatsFormatter) throws ConfigurationException {
        this.executionUnits = applicationEnvConfig.getExecutionUnits();
        this.executionUnitStacks = applicationEnvConfig.getExecutionUnitStacks();
        this.clientConfiguration = applicationEnvConfig.getClientConfiguration();
        Date now = new Date();
        this.endTime = new Date(now.getTime() + this.clientConfiguration.getRunTime());
        this.clientContext = ctx;
        this.executionUnitRunnerMonitor = executionUnitRunnerMonitor;
        this.executionUnitRunnerMonitor.setRunner(this);
        this.serverAdapterEventListenerList = serverAdapterEventListenerList;
        this.executionUnitEventListenerList = executionUnitEventListenerList;
        if (this.serverAdapterEventListenerList == null) {
            this.serverAdapterEventListenerList = new ArrayList<IServerAdapterEventListener>();
        }
        if (this.executionUnitEventListenerList == null) {
            this.executionUnitEventListenerList = new ArrayList<IExecutionUnitEventListener>();
        }
        this.serverAdapterEventListenerList.add(this.executionUnitRunnerMonitor);
        this.executionUnitEventListenerList.add(this.executionUnitRunnerMonitor);
        this.reportedMessageVisitor = reportedMessageVisitor;
        if (this.reportedMessageVisitor == null) {
            this.reportedMessageVisitor = this;
        }
        this.statsFormatter = executionStatsFormatter;
        if (this.statsFormatter == null) {
            this.statsFormatter = new ExecutionStatsFormatter("\n");
        }
        this.initializeLogger(this.clientContext);
    }

    public int getThreadId() {
        return this.clientContext.getThreadId();
    }

    public long getThreadLoopCounter() {
        return this.threadLoopCounter;
    }

    @Override
    public void run() {
        this.executeRun();
    }

    public void executeRun() {
        ExecutionStats.getInstance().addThreadToStats(this.getThreadId());
        ExecutionStats.getInstance().setThreadStartTime(this.getThreadId(), new Date());
        int printStatsInterval = 0;
        try {
            printStatsInterval = StringUtils.toInt(this.clientConfiguration.getConfiguration().getParameterValue(PRINT_STATS_INVTERVAL));
        }
        catch (NumberFormatException e) {
            this.logger.logp(Level.WARNING, this.getClass().getName(), "executeRun", "The parameter: print.stats.interval in the client config is not valid.  The default is set to 25.  Current value is: " + this.clientConfiguration.getConfiguration().getParameterValue(PRINT_STATS_INVTERVAL));
            printStatsInterval = 25;
        }
        int printStatsLoopCounter = 0;
        Date now = new Date();
        if (!this.suspendThread) {
            long initialActiveTime = -1L;
            long totalExecTime = 0L;
            do {
                Date startLoopTime = new Date();
                long totalEUDelayTime = 0L;
                ++this.threadLoopCounter;
                ExecutionStats.getInstance().incrumentThreadLoopCount(this.getThreadId());
                for (IExecutionUnit executionUnit : this.executionUnits) {
                    if (this.threadLoopCounter > 1L && executionUnit instanceof ISingleRunExecutionUnit) continue;
                    if (executionUnit instanceof IStackableExecutionUnit) {
                        String msg = "Invalid Configuration.  Found an Execution Unit that is instance of IStackableExecutionUnit but NOT inside a ExecutionUnitStack Element.  .  Ensure that EVERY The Executin Unit that is instance of IStackableExecutionUnit is inside an ExecutionUnitStack ..  EU Description: " + executionUnit.getDescription() + ".  The Execution will stop.";
                        System.out.println(msg);
                        this.reportMessage(msg);
                        this.suspendThread = true;
                        break;
                    }
                    this.reportMessage("executeRun: Thread Id: " + this.getThreadId() + " in loop counter: " + this.threadLoopCounter + " will execute EU: " + executionUnit.getDescription() + " on adapter: " + executionUnit.getServerAdapter().getClass().getName());
                    totalEUDelayTime = this.runTheEU(totalEUDelayTime, executionUnit);
                    this.reportMessage("executeRun: Thread Id: " + this.getThreadId() + " in loop cntr: " + this.threadLoopCounter + " completed Execution for EU: " + executionUnit.getDescription());
                    if (this.suspendThread) break;
                    if (++printStatsLoopCounter < printStatsInterval) continue;
                    this.reportMessage("executeRun: *** PRINT STATS THREASHOLD MET: PRINTING STATS ****");
                    this.printStats();
                    printStatsLoopCounter = 0;
                }
                this.reportMessage("Ready to run ExecutionUnitStacks.");
                for (IExecutionUnitStack stack : this.executionUnitStacks) {
                    this.reportMessage("ready to execute stack: " + stack.getDescription());
                    HashMap<String, Object> stackMap = new HashMap<String, Object>();
                    for (IExecutionUnit stackEU : stack.getStackExecutionUnits()) {
                        IStackableExecutionUnit eu = (IStackableExecutionUnit)stackEU;
                        eu.setStackMap(stackMap);
                        this.reportMessage("executeRun: Thread Id: " + this.getThreadId() + " in loop counter: " + this.threadLoopCounter + " will execute Stack EU: " + eu.getDescription() + " on adapter: " + eu.getServerAdapter().getClass().getName());
                        totalEUDelayTime = this.runTheEU(totalEUDelayTime, eu);
                        this.reportMessage("executeRun: Thread Id: " + this.getThreadId() + " in loop cntr: " + this.threadLoopCounter + " completed Execution for Stack EU: " + eu.getDescription());
                        if (!this.suspendThread) continue;
                        break;
                    }
                    stackMap.clear();
                    if (!this.suspendThread) continue;
                    break;
                }
                this.logger.logp(Level.FINER, this.getClass().getName(), "executeRun", "Thread Id " + this.getThreadId() + " in loop #: " + this.threadLoopCounter);
                now = new Date();
                this.logger.logp(Level.FINE, this.getClass().getName(), "executeRun", "endTime: " + this.endTime + " is after now? " + now + " " + this.endTime.after(now));
                Date endLoopTime = new Date();
                long clockTime = endLoopTime.getTime() - startLoopTime.getTime();
                long activeTime = clockTime - totalEUDelayTime;
                if (initialActiveTime == -1L) {
                    initialActiveTime = activeTime;
                }
                long averageActiveTime = (totalExecTime += activeTime) / this.threadLoopCounter;
                this.reportMessage("Thread id: " + this.getThreadId() + " loop number: " + this.threadLoopCounter + " started at: " + startLoopTime + " and ended at:" + endLoopTime + " which is: " + clockTime + " milliseconds (wall clock time)" + ".  Execution Unit Delay total was: " + totalEUDelayTime + ".  Hence Execution time was: " + activeTime + " milliseconds (active time)" + ".  First Loop Active Time is: " + initialActiveTime + ".  Average Active Time for all loops in this thread: " + averageActiveTime);
                ExecutionStats.getInstance().incrumentThreadClockTime(this.getThreadId(), clockTime);
                ExecutionStats.getInstance().incrumentThreadCPUTime(this.getThreadId(), activeTime);
            } while (this.endTime.after(now) && !this.suspendThread);
        }
        if (this.suspendThread) {
            ExecutionStats.getInstance().setThreadExecutionStatus(this.getThreadId(), ExecutionStatus.FAILED);
            ExecutionStats.getInstance().setThreadEndTime(this.getThreadId(), new Date());
            this.printStats();
            String msg = "Thread id: " + this.getThreadId() + " STOPPED and did NOT complete normally. Test has FAILED.";
            this.reportMessage(msg);
        } else {
            ExecutionStats.getInstance().setThreadExecutionStatus(this.getThreadId(), ExecutionStatus.PASSED);
            ExecutionStats.getInstance().setThreadEndTime(this.getThreadId(), new Date());
            this.printStats();
            this.reportMessage("Thread id: " + this.getThreadId() + " COMPLETED normally. This thread has PASSED.");
        }
    }

    private long runTheEU(long totalEUDelayTime, IExecutionUnit executionUnit) {
        executionUnit.setClientContext(this.clientContext);
        for (IExecutionUnitEventListener exEventListener : this.executionUnitEventListenerList) {
            executionUnit.addEventListener(exEventListener);
        }
        for (IServerAdapterEventListener serverAdapterEventListener : this.serverAdapterEventListenerList) {
            executionUnit.getServerAdapter().addEventListener(serverAdapterEventListener);
        }
        executionUnit.getServerAdapter().setClientContext(this.clientContext);
        totalEUDelayTime += this.processExecutionUnitStartDelay(executionUnit);
        executionUnit.execute();
        executionUnit.fireToListeners();
        executionUnit.getServerAdapter().fireToListeners();
        for (IExecutionUnitEventListener exEventListener : this.executionUnitEventListenerList) {
            executionUnit.removeEventListener(exEventListener);
        }
        for (IServerAdapterEventListener serverAdapterEventListener : this.serverAdapterEventListenerList) {
            executionUnit.getServerAdapter().removeEventListener(serverAdapterEventListener);
        }
        return totalEUDelayTime;
    }

    private long processExecutionUnitStartDelay(IExecutionUnit executionUnit) {
        block7: {
            String executionUnitDelayType = (String)executionUnit.getConfiguration().getParameterValue("executionUnitDelayType");
            String executionUnitDelayValueStr = (String)executionUnit.getConfiguration().getParameterValue("executionUnitDelayValue");
            long executionUnitDelayValue = 0L;
            if ("random".equalsIgnoreCase(executionUnitDelayType) || "constant".equalsIgnoreCase(executionUnitDelayType)) {
                try {
                    executionUnitDelayValue = Long.parseLong(executionUnitDelayValueStr);
                    if (executionUnitDelayValue <= 0L) {
                        throw new InvalidConfigurationException("invalid value for executionUnitDelayValue: " + executionUnitDelayValue);
                    }
                    if ("constant".equalsIgnoreCase(executionUnitDelayType)) {
                        Thread.sleep(executionUnitDelayValue);
                        return executionUnitDelayValue;
                    }
                    if ("random".equalsIgnoreCase(executionUnitDelayType)) {
                        long randValue = (int)Math.round(Math.random() * (double)executionUnitDelayValue);
                        Thread.sleep(randValue);
                        return randValue;
                    }
                    break block7;
                }
                catch (Throwable t) {
                    this.reportMessage("Invalid property value.  The property: executionUnitDelayValue value is: " + executionUnitDelayValueStr + " this value is invalid.  the value must be a valid long value greater than 0. Execution Unit Delay will be ignored.");
                    return 0L;
                }
            }
            if (executionUnitDelayType != null) {
                this.reportMessage("Invalid property value.  The property: executionUnitDelayType value is: " + executionUnitDelayType + " this value is invalid.  Valid values are random, constant.  Execution Unit Delay will be ignored.");
            }
            return 0L;
        }
        return 0L;
    }

    private synchronized void initializeLogger(ClientContext clientContext) {
        AcmeLoggerConfig.setClientFileNamePattern("", clientContext.getClientId(), clientContext.getThreadId(), this.clientConfiguration);
        Logger initialLogger = Logger.getLogger(clientContext.getPrefixedRootLoggerName());
        this.logger = AcmeLoggerFactory.getClientLogger(initialLogger, this.clientConfiguration, clientContext.getLoggerPrefix() + this.getClass().getName());
        clientContext.setRootLogger(initialLogger);
        this.reportMessage("initializeLogger Client Logging initialized.  Logger name: " + this.logger.getName());
    }

    private void printStats() {
        String formattedStats = this.statsFormatter.format();
        this.reportMessage(formattedStats);
    }

    @Override
    public int getRunnerId() {
        return this.getThreadId();
    }

    @Override
    public void reportMessage(String msg) {
        this.reportedMessage = msg;
        this.reportedMessageVisitor.visit(this);
    }

    @Override
    public String getReportedMessage() {
        return this.reportedMessage;
    }

    @Override
    public void stopRunner(String msg) {
        this.reportMessage("stopRunner: " + msg);
        this.logger.logp(Level.SEVERE, this.getClass().getName(), "stopRunner", "*** THREAD EXECUTION SHUTDOWN.  THREAD ID: " + this.getThreadId());
        this.suspendThread = true;
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public void setClientContext(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public void visit(IExecutionUnitRunner runner) {
        this.logger.logp(Level.INFO, this.getClass().getName(), "visit", runner.getReportedMessage());
    }
}

