/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client;

import com.ibm.wssvt.acme.common.adapter.IServerAdapterEvent;
import com.ibm.wssvt.acme.common.client.IExecutionUnitRunner;
import com.ibm.wssvt.acme.common.client.IExecutionUnitRunnerMonitor;
import com.ibm.wssvt.acme.common.envconfig.IApplicationEnvConfig;
import com.ibm.wssvt.acme.common.exception.ExceptionAction;
import com.ibm.wssvt.acme.common.exception.ExecutionUnitExceptionProcessor;
import com.ibm.wssvt.acme.common.exception.IExceptionHandlerResult;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnitEvent;
import com.ibm.wssvt.acme.common.stats.ExecutionStats;
import java.util.Date;

public class ExecutionUnitRunnerMonitor
implements IExecutionUnitRunnerMonitor {
    private static final long serialVersionUID = 6112098727998142387L;
    private IExecutionUnitRunner runner;
    private IApplicationEnvConfig applicationEnvConfig;

    public ExecutionUnitRunnerMonitor(IApplicationEnvConfig applicationEnvConfig) {
        this.applicationEnvConfig = applicationEnvConfig;
    }

    @Override
    public void processExecutionUnitEvent(IExecutionUnitEvent executionUnitEvent) {
        ExecutionUnitExceptionProcessor executionUnitExceptionProcessor = new ExecutionUnitExceptionProcessor();
        for (Exception exception : executionUnitEvent.getExceptions()) {
            int exceptionMaxCount;
            int maxMsgSize;
            IExceptionHandlerResult result = executionUnitExceptionProcessor.processException(this.applicationEnvConfig.getExceptionHandlers(), exception, executionUnitEvent.getExecutionUnit());
            if (ExceptionAction.REPORT.equals((Object)result.getAction())) {
                this.runner.reportMessage(result.getMessage());
                continue;
            }
            if (ExceptionAction.REPORT_AND_COUNT.equals((Object)result.getAction())) {
                this.runner.reportMessage(result.getMessage());
                maxMsgSize = 250;
                exceptionMaxCount = -1;
                try {
                    maxMsgSize = Integer.parseInt((String)executionUnitEvent.getExecutionUnit().getConfiguration().getParameterValue("ErrorMessageMaxSize"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    exceptionMaxCount = Integer.parseInt((String)executionUnitEvent.getExecutionUnit().getConfiguration().getParameterValue("exceptionMaxCount"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ExecutionStats.getInstance().incrumentExceptionStatsCount(exception, executionUnitEvent.getExecutionUnit().getClientContext().getThreadId(), new Date(), executionUnitEvent.getExecutionUnit().getDescription(), maxMsgSize, exceptionMaxCount);
                continue;
            }
            if (ExceptionAction.STOP.equals((Object)result.getAction())) {
                maxMsgSize = 250;
                exceptionMaxCount = -1;
                try {
                    maxMsgSize = Integer.parseInt((String)executionUnitEvent.getExecutionUnit().getConfiguration().getParameterValue("ErrorMessageMaxSize"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    exceptionMaxCount = Integer.parseInt((String)executionUnitEvent.getExecutionUnit().getConfiguration().getParameterValue("exceptionMaxCount"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ExecutionStats.getInstance().incrumentExceptionStatsCount(exception, executionUnitEvent.getExecutionUnit().getClientContext().getThreadId(), new Date(), executionUnitEvent.getExecutionUnit().getDescription(), maxMsgSize, exceptionMaxCount);
                this.runner.stopRunner(result.getMessage());
                break;
            }
            if (!ExceptionAction.IGNORE.equals((Object)result.getAction())) continue;
        }
    }

    @Override
    public void processServerAdapterEvent(IServerAdapterEvent serverAdapterEvent) {
        ExecutionStats.getInstance().incrumentRequest(serverAdapterEvent.getRequest());
        ExecutionStats.getInstance().incrumentCreate(serverAdapterEvent.getCreate());
        ExecutionStats.getInstance().incrumentRead(serverAdapterEvent.getRead());
        ExecutionStats.getInstance().incrumentUpdate(serverAdapterEvent.getUpdate());
        ExecutionStats.getInstance().incrumentDelete(serverAdapterEvent.getDelete());
        ExecutionStats.getInstance().incrumentFind(serverAdapterEvent.getFind());
        for (String serverName : serverAdapterEvent.getRunServerInfoCount().keySet()) {
            ExecutionStats.getInstance().incrumentServerRunInfo(serverName, serverAdapterEvent.getRunServerInfoCount().get(serverName));
        }
        for (String overallServerName : serverAdapterEvent.getOverallRunServerInfoCount().keySet()) {
            ExecutionStats.getInstance().incrumentOverallServerRunInfo(overallServerName, serverAdapterEvent.getOverallRunServerInfoCount().get(overallServerName));
        }
    }

    @Override
    public IExecutionUnitRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setRunner(IExecutionUnitRunner runner) {
        this.runner = runner;
    }
}

