/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.client.ui.gui.AcmeGUI;
import com.ibm.wssvt.acme.common.client.ui.gui.PropertiesDialog;
import com.ibm.wssvt.acme.common.client.ui.gui.RefreshableAcmeGuiPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClientConfigPanel
extends JPanel
implements RefreshableAcmeGuiPanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblClientConfigPrompt = null;
    private JLabel lblThreadCount = null;
    private JTextField txtThreadCount = null;
    private JLabel lblRuntime = null;
    private JLabel lblThreadExecDelay = null;
    private JTextField txtRuntime = null;
    private JTextField txtThreadExecDelay = null;
    private JButton btnClientEnvConfigConfiguration = null;
    private JLabel jLabel5 = null;
    private JTextField txtClientId = null;
    private JLabel lblClientConfigMsg = null;
    private JButton btnSetClientConfig = null;

    public ClientConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("Client Config");
        this.setSize(1076, 669);
        this.lblClientConfigMsg = new JLabel();
        this.lblClientConfigMsg.setBounds(new Rectangle(21, 156, 511, 16));
        this.lblClientConfigMsg.setForeground(new Color(255, 51, 51));
        this.lblClientConfigMsg.setText("");
        this.jLabel5 = new JLabel();
        this.jLabel5.setBounds(new Rectangle(19, 47, 143, 16));
        this.jLabel5.setText("Client ID (optional)");
        this.jLabel5.setToolTipText("The ID for the client.  It is recommended that this is left blank.");
        this.lblThreadExecDelay = new JLabel();
        this.lblThreadExecDelay.setBounds(new Rectangle(14, 131, 153, 16));
        this.lblThreadExecDelay.setText("Thread Execution Delay:");
        this.lblThreadExecDelay.setToolTipText("Time to wait (ms) before starting the next client thread.");
        this.lblRuntime = new JLabel();
        this.lblRuntime.setBounds(new Rectangle(13, 102, 152, 16));
        this.lblRuntime.setText("Minimum Runtime:");
        this.lblRuntime.setToolTipText("The amount of time (ms) after which client threads quit looping.");
        this.lblThreadCount = new JLabel();
        this.lblThreadCount.setBounds(new Rectangle(17, 76, 147, 16));
        this.lblThreadCount.setText("Thread Count");
        this.lblThreadCount.setToolTipText("The number of client threads to execute.");
        this.lblClientConfigPrompt = new JLabel();
        this.lblClientConfigPrompt.setBounds(new Rectangle(21, 14, 205, 16));
        this.lblClientConfigPrompt.setText("Provide the Client Config Data");
        this.setLayout(null);
        this.add((Component)this.lblClientConfigPrompt, null);
        this.add((Component)this.lblThreadCount, null);
        this.add((Component)this.getTxtThreadCount(), null);
        this.add((Component)this.lblRuntime, null);
        this.add((Component)this.lblThreadExecDelay, null);
        this.add((Component)this.getTxtRuntime(), null);
        this.add((Component)this.getTxtThreadExecDelay(), null);
        this.add((Component)this.getBtnClientEnvConfigConfiguration(), null);
        this.add((Component)this.jLabel5, null);
        this.add((Component)this.getTxtClientId(), null);
        this.add((Component)this.lblClientConfigMsg, null);
        this.add((Component)this.getBtnSetClientConfig(), null);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.txtClientId.setText(AcmeGUI.getConfiguredClientConfig().getId());
        this.txtThreadCount.setText("" + AcmeGUI.getConfiguredClientConfig().getThreadCount());
        this.txtRuntime.setText("" + AcmeGUI.getConfiguredClientConfig().getRunTime());
        this.txtThreadExecDelay.setText("" + AcmeGUI.getConfiguredClientConfig().getThreadExecDelay());
    }

    private JTextField getTxtThreadCount() {
        if (this.txtThreadCount == null) {
            this.txtThreadCount = new JTextField();
            this.txtThreadCount.setBounds(new Rectangle(181, 74, 167, 20));
        }
        return this.txtThreadCount;
    }

    private JTextField getTxtRuntime() {
        if (this.txtRuntime == null) {
            this.txtRuntime = new JTextField();
            this.txtRuntime.setBounds(new Rectangle(181, 104, 165, 20));
        }
        return this.txtRuntime;
    }

    private JTextField getTxtThreadExecDelay() {
        if (this.txtThreadExecDelay == null) {
            this.txtThreadExecDelay = new JTextField();
            this.txtThreadExecDelay.setBounds(new Rectangle(181, 130, 165, 20));
        }
        return this.txtThreadExecDelay;
    }

    private JButton getBtnClientEnvConfigConfiguration() {
        if (this.btnClientEnvConfigConfiguration == null) {
            this.btnClientEnvConfigConfiguration = new JButton();
            this.btnClientEnvConfigConfiguration.setBounds(new Rectangle(21, 180, 150, 28));
            this.btnClientEnvConfigConfiguration.setText("Configure Params");
            this.btnClientEnvConfigConfiguration.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClientConfigPanel.this.checkClientConfigElementData()) {
                        PropertiesDialog pd = new PropertiesDialog(AcmeGUI.getConfiguredClientConfig());
                        pd.setVisible(true);
                        ClientConfigPanel.this.lblClientConfigMsg.setText("");
                    }
                }
            });
        }
        return this.btnClientEnvConfigConfiguration;
    }

    private JTextField getTxtClientId() {
        if (this.txtClientId == null) {
            this.txtClientId = new JTextField();
            this.txtClientId.setBounds(new Rectangle(180, 46, 166, 20));
        }
        return this.txtClientId;
    }

    private boolean checkClientConfigElementData() {
        AcmeGUI.getConfiguredClientConfig().setId(this.txtClientId.getText());
        try {
            AcmeGUI.getConfiguredClientConfig().setRunTime(Long.parseLong(this.txtRuntime.getText()));
            if (AcmeGUI.getConfiguredClientConfig().getRunTime() < 1L) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            this.lblClientConfigMsg.setText("run time must be a valid number and greather than or equal 1");
            this.lblClientConfigMsg.setForeground(Color.RED);
            return false;
        }
        try {
            AcmeGUI.getConfiguredClientConfig().setThreadCount(Integer.parseInt(this.txtThreadCount.getText()));
            if (AcmeGUI.getConfiguredClientConfig().getThreadCount() < 1) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            this.lblClientConfigMsg.setText("thread count must be a valid number greather than or equal  1");
            this.lblClientConfigMsg.setForeground(Color.RED);
            return false;
        }
        try {
            AcmeGUI.getConfiguredClientConfig().setThreadExecDelay(Long.parseLong(this.txtThreadExecDelay.getText()));
            if (AcmeGUI.getConfiguredClientConfig().getThreadExecDelay() < 0L) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            this.lblClientConfigMsg.setText("Thread Exec delay must be a valid number. 0 or more.");
            this.lblClientConfigMsg.setForeground(Color.RED);
            return false;
        }
        return true;
    }

    private JButton getBtnSetClientConfig() {
        if (this.btnSetClientConfig == null) {
            this.btnSetClientConfig = new JButton();
            this.btnSetClientConfig.setBounds(new Rectangle(192, 180, 126, 28));
            this.btnSetClientConfig.setText("Set");
            this.btnSetClientConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClientConfigPanel.this.checkClientConfigElementData()) {
                        ClientConfigPanel.this.lblClientConfigMsg.setText("set OK!");
                        ClientConfigPanel.this.lblClientConfigMsg.setForeground(Color.BLACK);
                    }
                }
            });
        }
        return this.btnSetClientConfig;
    }
}

