/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.log;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AcmeLogger {
    private Logger logger;
    private List<String> records = new ArrayList<String>();

    public AcmeLogger(Logger l) {
        this.logger = l;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getAllLogs() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nSTART of ALL Logs:\n");
        for (String record : this.records) {
            sb.append(record);
            sb.append("\n");
        }
        sb.append("END of ALL Logs\n");
        this.records.clear();
        return sb.toString();
    }

    public void clearAllLogs() {
        this.records.clear();
    }

    public void config(String msg) {
        this.logger.logp(Level.CONFIG, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.CONFIG + " " + msg);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logger.entering(sourceClass, sourceMethod, param1);
        this.records.add("entering: " + sourceClass + " " + sourceMethod + " " + param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.entering(sourceClass, sourceMethod, params);
        this.records.add("entering: " + sourceClass + " " + sourceMethod + " " + params);
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entering(sourceClass, sourceMethod);
        this.records.add("entering: " + sourceClass + " " + sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logger.exiting(sourceClass, sourceMethod, result);
        this.records.add("exiting: " + sourceClass + " " + sourceMethod + " " + result);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exiting(sourceClass, sourceMethod);
        this.records.add("exiting: " + sourceClass + " " + sourceMethod);
    }

    public void fine(String msg) {
        this.logger.logp(Level.FINE, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.FINE + " " + msg);
    }

    public void finer(String msg) {
        this.logger.logp(Level.FINER, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.FINER + " " + msg);
    }

    public void finest(String msg) {
        this.logger.logp(Level.FINEST, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.FINEST + " " + msg);
    }

    public void info(String msg) {
        this.logger.logp(Level.INFO, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.INFO + " " + msg);
    }

    public void log(Level level, String msg, Object param1) {
        this.logger.logp(level, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg, param1);
        this.records.add(level + " " + msg + " " + param1);
    }

    public void log(Level level, String msg, Object[] params) {
        this.logger.logp(level, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg, params);
        this.records.add(level + " " + msg + " " + params);
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.logger.logp(level, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg, thrown);
        this.records.add(level + " " + msg + " " + thrown);
    }

    public void log(Level level, String msg) {
        this.logger.logp(level, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(level + " " + msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, param1);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + msg + " " + param1);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, params);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + msg + " " + params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, thrown);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + msg + " " + thrown);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.logger.logp(level, sourceClass, sourceMethod, msg);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + bundleName + " " + msg + " " + param1);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + bundleName + " " + msg + " " + params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + bundleName + " " + msg + " " + thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg);
        this.records.add(level + " " + sourceClass + " " + sourceMethod + " " + bundleName + " " + msg);
    }

    public void severe(String msg) {
        this.logger.logp(Level.SEVERE, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.SEVERE + " " + msg);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(sourceClass, sourceMethod, thrown);
        this.records.add("throwing: " + sourceClass + " " + sourceMethod + " " + thrown);
    }

    public void warning(String msg) {
        this.logger.logp(Level.WARNING, this.getStackTraceElementForLoggingClass().getClassName(), this.getStackTraceElementForLoggingClass().getMethodName(), msg);
        this.records.add(Level.WARNING + " " + msg);
    }

    private StackTraceElement getStackTraceElementForLoggingClass() {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        if (elements.length >= 2) {
            return elements[2];
        }
        return new StackTraceElement(this.getClass().getName(), "Unknown Method", "", 1);
    }
}

