/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.business.jaxrpc.beanconverter;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityBeansFactory;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityObject;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.RiderType;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Address;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Annuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.AnnuityPersistebleObject;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Contact;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Entry;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.EquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.FixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Payor;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Payout;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Rider;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.bean.Parameterizable;
import java.util.Calendar;
import java.util.Date;

public class JaxrpcBusinessBeanToJPABean {
    private static IAnnuityBeansFactory beansFactory = new JPABeansFactory();

    public static IAddress getAddress(Address in) {
        if (in == null) {
            return null;
        }
        IAddress out = beansFactory.createAddress();
        out.setCity(in.getCity());
        out.setCountry(in.getCountry());
        out.setLine1(in.getLine1());
        out.setLine2(in.getLine2());
        out.setState(in.getState());
        out.setZipCode(in.getZipCode());
        return out;
    }

    public static IContact getContact(Contact in) {
        if (in == null) {
            return null;
        }
        IContact out = beansFactory.createContact();
        out.setEmail(in.getEmail());
        out.setPhone(in.getPhone());
        out.setAddress(JaxrpcBusinessBeanToJPABean.getAddress(in.getAddress()));
        if (in.getContactType() != null) {
            out.setContactType(ContactType.valueOf(in.getContactType().getValue()));
        }
        JaxrpcBusinessBeanToJPABean.setConfigrableAtts(in, out);
        JaxrpcBusinessBeanToJPABean.setAnnuityObjectAtts(in, out);
        return out;
    }

    public static IAnnuityHolder getAnnuityHolder(AnnuityHolder in) {
        if (in == null) {
            return null;
        }
        IAnnuityHolder out = beansFactory.createAnnuityHolder();
        if (in.getCategory() != null) {
            out.setCategory(AnnuityHolderCategory.valueOf(in.getCategory().getValue()));
        }
        out.setContact(JaxrpcBusinessBeanToJPABean.getContact(in.getContact()));
        if (in.getDateOfBirth() != null) {
            out.setDateOfBirth(in.getDateOfBirth().getTime());
        }
        out.setFirstName(in.getFirstName());
        out.setLastName(in.getLastName());
        out.setGovernmentId(in.getGovernmentId());
        if (in.getPicture() == null) {
            out.setPicture(null);
        } else {
            Byte[] picArray = new Byte[in.getPicture().length];
            for (int i = 0; i < in.getPicture().length; ++i) {
                picArray[i] = in.getPicture()[i];
            }
            out.setPicture(picArray);
        }
        if (in.getTimeOfBirth() != null) {
            out.setTimeOfBirth(in.getTimeOfBirth().getTime());
        }
        JaxrpcBusinessBeanToJPABean.setAnnuityObjectAtts(in, out);
        JaxrpcBusinessBeanToJPABean.setConfigrableAtts(in, out);
        return out;
    }

    public static IAnnuity getAnnuity(Annuity in) {
        AnnuityPersistebleObject inp;
        int i;
        IAnnuity out;
        if (in == null) {
            return null;
        }
        if (in instanceof FixedAnnuity) {
            out = beansFactory.createAnnFixed();
            out.setRate(((FixedAnnuity)in).getRate());
        } else if (in instanceof EquityAnnuity) {
            out = beansFactory.createAnnEquity();
            ((IEquityAnnuity)out).setFundNames(((EquityAnnuity)in).getFundNames());
            ((IEquityAnnuity)out).setIndexRate(((EquityAnnuity)in).getIndexRate());
        } else {
            out = beansFactory.createAnnuity();
        }
        out.setAccountNumber(in.getAccountNumber());
        out.setAmount(in.getAmount());
        out.setAnnuityHolderId(in.getAnnuityHolderId());
        out.setLastPaidAmt(in.getLastPaidAmt());
        if (in.getPayors() != null) {
            for (i = 0; i < in.getPayors().length; ++i) {
                inp = in.getPayors()[i];
                IPayor outp = JaxrpcBusinessBeanToJPABean.getPayor(inp);
                out.getPayors().add(outp);
            }
        }
        if (in.getRiders() != null) {
            for (i = 0; i < in.getRiders().length; ++i) {
                Rider inr = in.getRiders()[i];
                IRider outr = JaxrpcBusinessBeanToJPABean.getRider(inr);
                out.getRiders().add(outr);
            }
        }
        if (in.getPayouts() != null) {
            for (i = 0; i < in.getPayouts().length; ++i) {
                inp = in.getPayouts()[i];
                IPayout p = JaxrpcBusinessBeanToJPABean.getPayoutWithNoAnnuity((Payout)inp);
                p.setAnnuity(out);
                out.getPayouts().add(p);
            }
        }
        JaxrpcBusinessBeanToJPABean.setAnnuityObjectAtts(in, out);
        JaxrpcBusinessBeanToJPABean.setConfigrableAtts(in, out);
        return out;
    }

    public static IPayout getPayoutWithNoAnnuity(Payout in) {
        if (in == null) {
            return null;
        }
        IPayout out = beansFactory.createPayout();
        out.setTaxableAmount(in.getTaxableAmount());
        out.setEndDate(in.getEndDate());
        out.setStartDate(in.getStartDate());
        JaxrpcBusinessBeanToJPABean.setAnnuityObjectAtts(in, out);
        JaxrpcBusinessBeanToJPABean.setConfigrableAtts(in, out);
        return out;
    }

    public static IPayout getPayout(Payout in) {
        if (in == null) {
            return null;
        }
        IPayout out = JaxrpcBusinessBeanToJPABean.getPayoutWithNoAnnuity(in);
        out.setAnnuity(JaxrpcBusinessBeanToJPABean.getAnnuity(in.getAnnuity()));
        return out;
    }

    public static IRider getRider(Rider in) {
        if (in == null) {
            return null;
        }
        IRider out = beansFactory.createRider();
        out.setRule(in.getRule());
        if (in.getEffectiveDate() != null) {
            out.setEffectiveDate(in.getEffectiveDate().getTime());
        }
        if (in.getType() != null) {
            out.setType(RiderType.valueOf(in.getType().getValue()));
        }
        JaxrpcBusinessBeanToJPABean.setAnnuityObjectAtts(in, out);
        JaxrpcBusinessBeanToJPABean.setConfigrableAtts(in, out);
        return out;
    }

    public static IPayor getPayor(Payor in) {
        if (in == null) {
            return null;
        }
        IPayor out = beansFactory.createPayor();
        out.setName(in.getName());
        JaxrpcBusinessBeanToJPABean.setAnnuityObjectAtts(in, out);
        JaxrpcBusinessBeanToJPABean.setConfigrableAtts(in, out);
        return out;
    }

    public static void dateToCalendar(Date in, Calendar out) {
        if (in == null) {
            out = null;
        } else {
            out.setTime(in);
        }
    }

    public static void setAnnuityObjectAtts(AnnuityPersistebleObject in, IAnnuityObject out) {
        out.setId(in.getId());
        out.setVersion(in.getVersion());
        if (in.getLastUpdateDate() != null) {
            out.setLastUpdateDate(in.getLastUpdateDate().getTime());
        }
    }

    public static void setConfigrableAtts(AnnuityPersistebleObject in, Configrable<String, String> out) {
        if (in.getConfig() == null || in.getConfig().getParams() == null) {
            return;
        }
        Parameterizable sp = beansFactory.createParameterizable();
        Entry[] entryList = in.getConfig().getParams();
        for (int i = 0; i < entryList.length; ++i) {
            Entry entry = entryList[i];
            sp.addParameter((Object)entry.getKey(), (Object)entry.getValue());
        }
        out.setConfiguration(sp);
    }
}

