/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AsynchMethodHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.List;

public class CRUDHoldeAndAnnuityEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8978758038714550844L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating Contact");
        IContact contact = null;
        try {
            contact = this.createContact();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Contact");
        try {
            this.verifyCreate(contact);
        }
        catch (Exception e) {
            this.logger.info("Create Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Creating AnnuityHolder");
        IAnnuityHolder holder = null;
        try {
            holder = this.createAnnuityHolder(contact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to create AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create AnnuityHolder");
        try {
            this.verifyCreate(holder);
        }
        catch (Exception e) {
            this.logger.info("Create AnnuityHolder verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Creating Annuity");
        IAnnuity annuity = null;
        AnnuityType annuityType = this.getRandomEnum(AnnuityType.class);
        try {
            annuity = this.createAnnuity(holder, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Annuity. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Annuity");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.info("Create Annuity verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating Contact");
        IContact updatedContact = null;
        try {
            updatedContact = this.updateContact(contact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update Contact");
        try {
            this.verifyUpdate(updatedContact);
        }
        catch (Exception e) {
            this.logger.info("Update Contact verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating AnnuityHolder");
        IAnnuityHolder updatedHolder = null;
        try {
            updatedHolder = this.updateAnnuityHolder(holder, updatedContact);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update AnnuityHolder");
        try {
            this.verifyUpdate(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Update AnnuityHolder verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating AnnuityHolder with annuity");
        try {
            updatedHolder = this.updateAnnuityHolderWithAnnuity(updatedHolder);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update AnnuityHolder");
        try {
            this.verifyUpdate(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Update AnnuityHolder verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting AnnuityHolder");
        try {
            this.deleteAnnuityHolder(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete AnnuityHolder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete AnnuityHolder");
        try {
            this.verifyDelete(updatedHolder);
        }
        catch (Exception e) {
            this.logger.info("Delete AnnuityHolder verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting Contact");
        try {
            this.deleteContact(updatedContact);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Contact. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete Contact");
        try {
            this.verifyDelete(updatedContact);
        }
        catch (Exception e) {
            this.logger.info("Delete Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IAnnuityHolder createAnnuityHolder(IContact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        holder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        holder.setContact(contact);
        holder.setConfiguration(this.getConfiguration());
        holder = this.getServerAdapter().createAnnuityHolder(holder);
        return holder;
    }

    private IAnnuityHolder updateAnnuityHolder(IAnnuityHolder before, IContact updatedContact) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder after = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findHolderById(after);
        after.setGovernmentId(after.getGovernmentId() + "-updated");
        after.setContact(updatedContact);
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateAnnuityHolder(after);
        return after;
    }

    private void deleteAnnuityHolder(IAnnuityHolder holder) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder removed = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        removed.setId(holder.getId());
        removed.setConfiguration(this.getConfiguration());
        List<IAnnuity> annuities = this.getServerAdapter().findHolderAnnuities(removed);
        for (IAnnuity annuity : annuities) {
            IAnnuity updated = BasicExecutionUnitLibrarry.getBasicAnnuity(this.getAnnuityBeansFactory());
            updated.setId(annuity.getId());
            updated.setConfiguration(this.getConfiguration());
            updated = this.getServerAdapter().findAnnuityById(updated);
            updated.setAnnuityHolderId(null);
            updated.setConfiguration(this.getConfiguration());
            updated = this.getServerAdapter().updateAnnuity(updated);
            updated.setConfiguration(this.getConfiguration());
            this.getServerAdapter().deleteAnnuityById(updated);
        }
        this.getServerAdapter().deleteAnnuityHolder(removed);
    }

    private void verifyCreate(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(holder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, holder, results, "AnnuityHolder from client is not equal to DB value", "AnnuityHolder Create mismacth was found.");
    }

    private void verifyUpdate(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(holder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, holder, results, "AnnuityHolder from client is not equal to DB value", "AnnuityHolder Update mismacth was found.");
    }

    private void verifyDelete(IAnnuityHolder holder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InvalidExecutionUnitParameterException, InterruptedException {
        AsynchMethodHelper.verifyHolderDelete(holder, this, this.logger);
    }

    private IContact createContact() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        contact.setConfiguration(this.getConfiguration());
        contact.setContactType(this.getRandomEnum(ContactType.class));
        contact = this.getServerAdapter().createContact(contact);
        return contact;
    }

    private IContact updateContact(IContact before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IContact after = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findContactById(after);
        after.setPhone(after.getPhone() + "-updated");
        after.setEmail(after.getEmail() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateContact(after);
        return after;
    }

    private void deleteContact(IContact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact removed = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        removed.setId(contact.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteContact(removed);
    }

    private void verifyCreate(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "Contact from client is not equal to DB value", "Contact Create mismacth was found.");
    }

    private void verifyUpdate(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "Contact from client is not equal to DB value", "Contact Update mismacth was found.");
    }

    private void verifyDelete(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InvalidExecutionUnitParameterException, InterruptedException {
        AsynchMethodHelper.verifyContactDelete(contact, this, this.logger);
    }

    private IAnnuity createAnnuity(IAnnuityHolder holder, AnnuityType annuityType) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
        annuity.setAnnuityHolderId((String)holder.getId());
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().createAnnuity(annuity);
        return annuity;
    }

    private IAnnuityHolder updateAnnuityHolderWithAnnuity(IAnnuityHolder holder) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity annuity2 = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), this.getRandomEnum(AnnuityType.class));
        annuity2.setAnnuityHolderId((String)holder.getId());
        annuity2.setConfiguration(this.getConfiguration());
        annuity2 = this.getServerAdapter().createAnnuity(annuity2);
        IAnnuityHolder updatedHolder = this.getAnnuityBeansFactory().createAnnuityHolder();
        updatedHolder.setId(holder.getId());
        updatedHolder.setConfiguration(this.getConfiguration());
        List<IAnnuity> annuities = this.getServerAdapter().findHolderAnnuities(updatedHolder);
        IAnnuity removed = BasicExecutionUnitLibrarry.getBasicAnnuity(this.getAnnuityBeansFactory());
        removed.setId(annuities.get(0).getId());
        removed.setConfiguration(this.getConfiguration());
        removed = this.getServerAdapter().findAnnuityById(removed);
        removed.setAnnuityHolderId(null);
        removed.setConfiguration(this.getConfiguration());
        removed = this.getServerAdapter().updateAnnuity(removed);
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteAnnuityById(removed);
        IAnnuity annuity3 = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), this.getRandomEnum(AnnuityType.class));
        annuity3.setAnnuityHolderId((String)holder.getId());
        annuity3.setConfiguration(this.getConfiguration());
        annuity3 = this.getServerAdapter().createAnnuity(annuity3);
        return holder;
    }

    private void verifyAnnuityValues(IAnnuity annuity, AnnuityType annuityType) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        int i;
        IAnnuity results = null;
        if (AnnuityType.BASIC.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnuity();
        }
        if (AnnuityType.EQUITY.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnEquity();
        }
        if (AnnuityType.FIXED.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnFixed();
        }
        results.setId(annuity.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findAnnuityById(results);
        if (annuity instanceof IFixedAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IFixedAnnuity)annuity, (IFixedAnnuity)results, "Fixed Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IEquityAnnuity)annuity, (IEquityAnnuity)results, "Equity Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity, results, "Basic Annuity from Client is not equal to DB value", "Mismacth was found.");
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
    }
}

