/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuityException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CreateAnnuityWithProvidedIdEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -3967925682867028969L;
    private static final String ANNUITY_TYPE = "annuityType";
    private static final String ID = "id";

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            AnnuityType annuityType = super.getParameterValueEnum(AnnuityType.class, ANNUITY_TYPE);
            IAnnuity annuity = this.createAnnuity(annuityType);
            this.verifySuccess(annuity);
            logger.fine("Annuity created ID=" + (String)annuity.getId());
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private IAnnuity createAnnuity(AnnuityType annuityType) throws AnnuityException, ServerAdapterCommunicationException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
        annuity.setConfiguration(this.getConfiguration());
        annuity.setId(this.getConfiguration().getParameterValue((Object)ID));
        this.getServerAdapter().createAnnuity(annuity);
        return annuity;
    }

    private void verifySuccess(IAnnuity annuity) throws ExecutionUnitVerificationException {
        if (annuity == null) {
            throw new ExecutionUnitVerificationException("Create Annuity Failed.  Returned object is null");
        }
        if (annuity.getId() == null) {
            throw new ExecutionUnitVerificationException("Create Annuity Failed. Returned object id == null");
        }
    }
}

