/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class DuplicateHolderCreateEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -7924793447916434856L;
    private String useId = null;
    private int startHolderId = 0;
    private int endHolderId = 0;
    boolean enableVerify = true;
    private static final String ENABLE_VERIFY_KEY = "enableVerify";
    private static final String USE_ID = "useId";
    private static final String START_ID = "startHolderId";
    private static final String END_ID = "endHolderId";
    AcmeLogger logger = null;

    public void execute() {
        this.setScenarioVariables();
        String sHolderId = null;
        IAnnuityHolder annuityHolderReturn = null;
        if (this.useId == null && this.endHolderId == 0) {
            this.logger.severe("Scenario parameter error: Either useId or endHolderId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            InvalidArgumentException e = new InvalidArgumentException("Scenario parameter error: Either useId or endHolderId must be set > 0 for scenario");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        sHolderId = this.useId == null ? "" + (this.startHolderId + this.getRandomInteger(0, this.endHolderId - this.startHolderId)) : this.useId;
        this.logger.fine("Looking up id: " + sHolderId);
        try {
            annuityHolderReturn = this.findAnnuityHolder(sHolderId);
        }
        catch (Exception e) {
            this.logger.warning("Failed to find AnnuityHolder, Id = " + sHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)annuityHolderReturn.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.info("Failed on verify find annuity holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Creating annuity holder, id " + (String)annuityHolderReturn.getId());
        IAnnuityHolder annuityHolder = null;
        try {
            annuityHolder = this.createAnnuityHolder((String)annuityHolderReturn.getId());
            this.logger.warning("Failed on create duplicate Holder, created instead of expected exception. Error: ");
            this.logger.warning("Created id = " + (String)annuityHolder.getId());
            ExecutionUnitVerificationException e = new ExecutionUnitVerificationException("Failed on create duplicate Holder, created instead of expected exception. Error: ");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            if (ServerExceptionType.ENTITY_ALREADY_EXISTS_EXCEPTION.equals((Object)ServerExceptionMapper.getExceptionType(e))) {
                this.logger.fine("Success, received expected exception when trying to create an existing Annuity");
                return;
            }
            this.logger.info("Failed on creating duplicate Annuity. expecting EntityAlreadyExistsException, got: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.enableVerify = this.getParameterValueBoolean(ENABLE_VERIFY_KEY);
        }
        catch (InvalidExecutionUnitParameterException e1) {
            this.logger.warning("Missing or invalid value for: enableVerify parameter.  for scenario: " + this.getDescription() + "Defaulting to true." + " current value is: " + (String)this.getConfiguration().getParameterValue((Object)ENABLE_VERIFY_KEY));
            this.enableVerify = true;
        }
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
            this.endHolderId = 0;
            this.startHolderId = 0;
        }
        catch (Exception e) {
            this.logger.fine("useId parameter not in config file, use random");
        }
        if (this.useId == null) {
            try {
                this.startHolderId = this.getParameterValueInt(START_ID);
            }
            catch (Exception e) {
                this.logger.fine("startHolderId parameter not in config file, use default startHolderId");
            }
            try {
                this.endHolderId = this.getParameterValueInt(END_ID);
            }
            catch (Exception e) {
                this.logger.fine("endHolderId parameter not in config file, use default endHolderId");
            }
        }
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }

    private IAnnuityHolder createAnnuityHolder(String id) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder.setId(id);
        annuityHolder = this.getServerAdapter().createAnnuityHolder(annuityHolder);
        return annuityHolder;
    }
}

